# delimit ;
program drop _all;
capture log close;
set more 1;  
clear; 
set mem 300m; 
local divide 2; 
set seed 8309830;
* set this to 1 if include 2020 wave;
*global INCLUDE2020 1;
global folder "D:\Dropbox";

*global folder "C:\research";
*global folder "C:\Users\Jeremy\Dropbox";
*global folder "~/";
*global folder "C:\Users\ebf26\Dropbox";
*global folder "\\econ-san-fs\Home4\uctpkp0\SystemFolder\Windows7\Desktop";
*global folder "C:\Users\Eric\Dropbox";

*global folder "\\econ-san-fs\Home4\uctpkp0\SystemFolder\Windows7\Desktop";

*global folder "\\ad.ucl.ac.uk\homer\zctpmer\downloads";


         local saved  "$folder\hrs\merge\";
         local trackd "$folder\hrs\tracker\";
         local wave1d "$folder\hrs\wave1\";
         local wave2d "$folder\hrs\wave2\";
         local wave3d "$folder\hrs\wave3\";
         local wave4d "$folder\hrs\wave4\";
         local wave5d "$folder\hrs\wave5\";
		 local wave6d "$folder\hrs\wave6\";
         local wave7d "$folder\hrs\wave7\";
         local wave8d "$folder\hrs\wave8\";
		 local wave9d "$folder\hrs\wave9\";
		 local wave10d "$folder\hrs\wave10\";
		 local wave11d "$folder\hrs\wave11\";
		 local wave12d "$folder\hrs\wave12\";
		 local wave13d "$folder\hrs\wave13\";	
		 local wave14d "$folder\hrs\wave14\";
		 local wave15d "$folder\hrs\wave15\";
         local aheadw1 "$folder\hrs\aheadw1\";
         local aheadw2 "$folder\hrs\aheadw2\";
		 
log using `saved'exitassets.log, replace;

***************************************COMMENTS********************************;

*********************************************ESTATE****************************;

/*In waves 2, 3, and 4 (1995, 1996, and 1998) the question asked about the total value of the estate, without specifying whether the value of the
house should be included in the total value of the estate or not.  However, from the bequest.do file and from Hurd and Smith's paper, 
it looks like singles DID include the value of the house in the total value of estate, while couples DID NOT.  According to most of states' laws,
the house is owned jointly by both spouses.  So, in a case when one spouse dies, the house automatically belongs to the surviving spouse,
so it is NOT considered part of the estate.  In other words, the spouse does not inherit the house, it already belongs to him/her.
On the other hand, in case of a single person, the house is considered as part of estate and passes to his/her heirs. */

*In waves 5 and 6 (2000 & 2002), the question specifies that the value of the house/life insurance SHOULD NOT be included in the value of estate;

                    
* Also included in the file are the amount of death expenses (burial fees, etc.), life insurance, and insurance that covers death expenses (excluding life insurance);
*These variables are deathex* inspay* and deathins*, respectively;


***********************************HOUSE****************;

*For AHEAD wave 2,  the house and re (re stands for a second home) are divided into 1) the house was disposed of before the respondent died but after
* the last time HRS interviewed the respondent or 2): the house was disposed of after the person died;
* the variables housebequeathXZ stand for what was done with the house ;
* housebequeathAZ is for wave Z, a respondent still owned home at time of death--what did he/she do with it: 1=> gift, 2=> sold it, 7 other, 8 DK, 9 RF;
* housebequeathBZ is for wave Z, what happended to the house after respondent's death-- 1=> surviving spouse still owns it, 2 sold, 3 inheritance, 
* 4 not yet disposed of, 6 home was foreclosed, 7 other, 8 DK, 9 RF;

*housebequeathCZ same format as housebequeathAZ but for second home;
*housebequeathDZ is same format as  housebequeathBZ but for the second home;

*The question about the price of the house is different in waves 5 and 6 from the previous waves.
*In waves 2,3, and 4 it asks what was the selling price of the house in a case IF the house was sold.
*In waves 5 and 6, the question asks what was the market price of the house, meaning what was would the house cost,
*even if it WERE NOT sold!

*In codebook housebequeathAZ and housebequeathCZ under heading "Happened to Home"--wave 6 "Disposition of Main/2nd Home";
*In codebook housebequeathBZ and housebequeathDZ  under heading "HOME DISPOSAL"--wave 6 "final Disposition of Maon/2nd Home";

*******************************IMPUTATIONS************************************;

/* Estateflag* is a flag variable, which shows what information was available for imputation procedure.
Estateflag* can be equal to seven possible values: 1, 2,3,4, 5, 6, and 7. Estateflag*=1 stands for Legitimate Missing or Partial Interview
(where legitimate missing means "not applicable", i.e. if the question is about a spouse, and the person is single. By default, a legitimate missing
on the amount variable is set to zero), estateflag*=2 stands for Valid Value,
estateflag*=3 stands for Closed Bracket; *estateflag*=4 stands for Bottom-Open Bracket, estateflag*=5 Top-Open Bracket;
*estateflag*=6 Imputation with no Bracket Information, estateflag*=7 Imputed Ownership and amount*/

*More detailed information on imputation procedures can be found in "Impute: A SAS Application System for Missing Value Imputations" by
*Honggao Cao, July 2001;



*XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX;
*XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXprogram define imputethis;
program define imputethis;

egen recipgrp = group(lowervalue uppervalue);
tab recipgrp;
egen numgroup = max(recipgrp);
local num = numgroup[100];
display `num';
sum uppervalue;
local maxup = r(max);

gen exactvalueimpute=.;

*imputation algorithm here*****************************;

local ii =1;
while `ii' <= `num' {;

*first get upper and lower bounds ;
gen mygroup=1;
replace mygroup=0 if recipgrp == `ii';

sum recipgrp if recipgrp == `ii';

sort mygroup;

local mymin= lowervalue[1];
local mymax= uppervalue[1];

qui sum exactvalue if mmiss==0 & exactvalue>=`mymin' & exactvalue<=`mymax' ;
local max = r(N); * number of "donors";

qui sum exactvalue if exactvalue~=. & ((exactvalue>=`mymin' & exactvalue<=`mymax')|(mygroup==0));
local max2 = r(N); *number of "recipients";

gen sortflag = 1;
replace sortflag = 0 if exactvalue~=. & ((exactvalue>=`mymin' & exactvalue<=`mymax')|(mygroup==0));
gen sortflag2 = 1;
replace sortflag2 = 0 if mmiss==0 & exactvalue>=`mymin' & exactvalue<=`mymax' ;

sort sortflag sortflag2  HHID PN; 

	local i=1;
	while `i' <= `max2' {;
	  local i2 = ceil(uniform()*`max');


if (`max'>0 & `max'<999999999) {;
	  qui replace exactvalueimpute = exactvalue[`i2'] in `i';
};
if (`max'<1 |  `max'>999999998) {;
	  qui replace exactvalueimpute = sqrt((lowervalue+10)*uppervalue) in `i' if uppervalue~=`maxup';
	  qui replace exactvalueimpute = lowervalue in `i' if uppervalue==`maxup';

display `max2';
display `max';
sum mygroup;

};


*};
	  local i = `i' + 1;
	};



drop mygroup sortflag sortflag2;
local ii = `ii' + 1;
};

replace exactvalue=exactvalueimpute if mmiss==1;
replace exactvalue=0 if mmiss==.;
sort mmiss;
by mmiss: sum exactvalue;

drop mmiss recipgrp numgroup exactvalueimpute;


end;




**********************************************************;
*************************AHEAD WAVE II**************************;
clear; 
use `aheadw2'x95i_nr; //imputation file;

gen house2=N4833X+N4845X;
*where N4833-denotes "the house was disposed of before the respondent died but after the last time HRS interviewed the respondent" 
*and N4845 denotes "the house was disposed of after the person died";


gen estate1=.;
gen estateflag1=.; 
gen estateflag6=.;
*gen housebequeathA1=.;
*gen housebequeathB1=.;
*gen housebequeathC1=.;
*gen housebequeathD1=.;
gen inspay1=.;
gen deathex1=.;
gen deathins1=.;
gen house1=.; //these 11 commands are not doing anything, they are needed just for consistency in notation;


*************************************Estate, wave2***************************************;

desc N5204X N5123Z N5134Z N5156Z N5166Z N5176Z N5186Z N5196Z;
sum N5204X N5123Z N5134Z N5156Z N5166Z N5176Z N5186Z N5196Z;

gen estate2=N5204X;
replace estate2=. if estate2>3000000;
gen amspouse2=N5123Z;//amount to spouse, wave2;
gen amchildren2=N5134Z;//total amount to children, wave2;
gen perchildren2=N5135X; //total percentage to children, wave2;
gen amcharities2=N5156Z;//amount to charities;
gen amsiblings2=N5166Z; //amount to siblings;
gen amrelatives2=N5176Z; //amount to relatives;
gen amfriends2=N5186Z; //amount to friends;
gen amothers2=N5196Z; //amount to others, wave2;

sum estate2 am* per*2;

gen estatesum2=amspouse2+amchildren2+amcharities2+amsiblings2+amrelatives2+amfriends2+amothers2;


******************************Breakdown of amounts to children**********************************;

desc N51451Z N51452Z N51453Z N51454Z N51455Z N51456Z N51457Z N51458Z N51459Z N514510Z;
sum N51451Z N51452Z N51453Z N51454Z N51455Z N51456Z N51457Z N51458Z N51459Z N514510Z;


gen amchild12=N51451Z;//amount to child 1, wave2;
gen amchild22=N51452Z;//amount to child 2, wave2;
gen amchild32=N51453Z;
gen amchild42=N51454Z;
gen amchild52=N51455Z; 
gen amchild62=N51456Z;
gen amchild72=N51457Z;
gen amchild82=N51458Z; 
gen amchild92=N51459Z;
gen amchild102=N514510Z; //amount to child 10, wave2;

gen amchildrentot2= amchild12+amchild22+amchild32+amchild42+amchild52+amchild62+amchild72+amchild82+amchild92+amchild102;

*replace amchildrentot2=. if amchildrentot2>600000;

*two sc amchildrentot2 amchildren2 if (amchildren2<1000000 & amchildrentot2<1000000);

*amchildrentot2 should be somewhat equal to amchildren2;


******************************Breakdown of percentages to children******************************;

desc   N51461X N51462X N51463X N51464X N51465X N51466X N51467X  N51468X N51469X N514610X;
sum  N51461X N51462X N51463X N51464X N51465X N51466X N51467X  N51468X N51469X N514610X;

gen perchild12=N51461X;//percent of the estate to child1, wave2;
gen perchild22=N51462X;
gen perchild32=N51463X;
gen perchild42=N51464X;
gen perchild52=N51465X;
gen perchild62=N51466X;
gen perchild72=N51467X;
gen perchild82=N51468X;
gen perchild92=N51469X;
gen perchild102=N514610X;//percent of the estate to child10, wave2;
gen perchildrentot2=perchild12+perchild22+perchild32+perchild42+perchild52+perchild62+perchild72+perchild82+perchild92+perchild102;

sum perchild* amchild* estate2 if estate2<3500000;

*amchildrentot2 should be somewhat equal to amchildren2, but it's not!;


*stop;



sum N5204X if N5204X<10000000;
sum N5204X if N5204X<1000000;


gen estateflag2=N5204T; //see comments for the description of estateflag variable;

gen inspay2=N5246X;

gen deathex2=N5102X;

gen deathins2=N5108X;

keep death*  HHID PN house* estate* estateflag* inspay* N4833X N4845X am* per*; 

gen temp=real(HHID); 
drop HHID; 
rename temp HHID; 
gen temp=real(PN); 
drop PN; 
rename temp PN; 
sort HHID PN; 

summ;

*merge HHID PN using `saved'exitassets; 
*drop _merge; 
sort HHID PN; 
sleep 1000;
save `saved'exitassets, replace;
clear;
***********************************************************; 
use `aheadw2'x95N_R; // asset file; *Jon: I changed the directory from aheadw2 to aheadw2exit;

gen temp=real(HHID); 
drop HHID; 
rename temp HHID; 
gen temp=real(PN); 
drop PN; 
rename temp PN; 

gen re2= N4873+N4885;
*Variables N4873+N4885 have no values; *re stands for the second home;

gen housebequeathA2=N4822;

gen housebequeathB2=N4841;

gen housebequeathC2=N4858;

gen housebequeathD2=N4881;



sort HHID PN;
merge HHID PN using `saved'exitassets; 
drop _merge; 



keep death*  HHID PN house* estate* inspay* re* am* per*;


summ;
sort HHID PN; 
sleep 1000;
save `saved'exitassets, replace;
drop _all;

*********************HRS WAVE 3*****************************;

clear;
use `wave3d'x96i_nr; // imputation file;
gen temp=real(HHID); 
drop HHID; 
rename temp HHID; 
gen temp=real(PN); 
drop PN; 
rename temp PN; 

gen inspay3=P2137X;
gen estateflag3=P2095T;

*where 1. denotes Legitimate Missing or Partial Interview, 2. Valid Value,3. Closed Bracket;
* 4. Bottom-Open Bracket,6. Imputation with no Bracket Information, 7.Imputed Ownership and amount;

********************estate, wave3**************;

desc P2095X P2014Z P2025Z P2047Z P2057Z P2067Z P2077Z;
sum P2095X P2014Z P2025Z P2047Z P2057Z P2067Z P2077Z;

gen estate3=P2095X;
gen amspouse3=P2014Z;//amount to spouse, wave3;
gen amchildren3=P2025Z;//total amount to children, wave3;
gen perchildren3=P2026X; //total percentage to children, wave3;
gen amcharities3=P2047Z; //amount to charities;
gen amsiblings3=P2057Z; //amount to siblings;
gen amrelatives3=P2067Z; //amount to relatives;
gen amfriends3=P2077Z; //amount to friends;
*gen amothers3=P2087Z; *the "amount to others" variable is not in the dataset, although it is in the description of the dataset;
gen amothers3=0; // set to 0, but very disturbing;
gen estatesum3=amspouse3+amchildren3+amcharities3+amsiblings3+amrelatives3+amfriends3+amothers3;

sum estate3 am*3 per*3;

******************************Breakdown of amounts to children**********************************;

desc P20361Z P20362Z P20363Z P20364Z P20365Z P20366Z P20367Z P20368Z P20369Z P203610Z;            
sum P20361Z P20362Z P20363Z P20364Z P20365Z P20366Z P20367Z P20368Z P20369Z P203610Z;


gen amchild13=P20361Z;//amount to child 1, wave3;
gen amchild23=P20362Z;//amount to child 2, wave3;
gen amchild33=P20363Z;
gen amchild43=P20364Z;
gen amchild53=P20365Z; 
gen amchild63=P20366Z;
gen amchild73=P20367Z;
gen amchild83=P20368Z; 
gen amchild93=P20369Z;
gen amchild103=P203610Z;//amount to child 10, wave3;

gen amchildrentot3= amchild13+amchild23+amchild33+amchild43+amchild53+amchild63+amchild73+amchild83+amchild93+amchild103;
*amchildrentot3 should be somewhat equal to amchildren3;
*two sc amchildrentot3 amchildren3 if (amchildren3<1000000 & amchildrentot3<1000000);

******************************Breakdown of percentages to children******************************;

desc P20371X P20372X P20373X P20374X P20375X P20376X P20377X P20378X P20379X P203710X;            
sum P20371X P20372X P20373X P20374X P20375X P20376X P20377X P20378X P20379X P203710X; 

gen perchild13=P20371X;
gen perchild23=P20372X;
gen perchild33=P20373X;
gen perchild43=P20374X;
gen perchild53=P20375X;
gen perchild63=P20376X;
gen perchild73=P20377X;
gen perchild83=P20378X;
gen perchild93=P20379X;
gen perchild103=P203710X;
gen perchildrentot3=perchild13+perchild23+perchild33+perchild43+perchild53+perchild63+perchild73+perchild83+perchild93+perchild103;
sum perchild*3 amchild*3 estate3;

*amchildrentot3 should be somewhat equal to amchildren3, but it's not!;

*stop;

sort HHID PN;
merge HHID PN using `saved'exitassets; 
drop _merge; 

summ;
sort HHID PN;
sleep 1000;
save `saved'exitassets, replace;
drop _all;

********************************************************************************;
use `wave3d'x96N_R; //asset file; 

gen temp=real(HHID); 
drop HHID; 
rename temp HHID; 
gen temp=real(PN); 
drop PN; 
rename temp PN; 

replace P1927=0 if P1927==. |P1927>9000000;
replace P1915=0 if P1915==. |P1915>9000000;
gen house3=P1927+P1915;

gen re3=P1967;
replace re3=0 if re3==. |re3>9000000;
*P1955 2nd home disposed of before death all blank responses;

gen housebequeathA3=P1904;

gen housebequeathB3=P1923;

gen housebequeathC3=P1940;

gen housebequeathD3=P1963;

gen deathex3=P1993;
gen temp=deathex3;
replace temp=. if deathex3>90000 & deathex3~=.;
drop deathex3;
rename temp deathex3;

gen deathins3=P1999;
gen temp=deathins3;
replace temp=. if deathins3>9990000 & deathins3~=.;
drop deathins3;
rename temp deathins3;


sort HHID PN;
merge HHID PN using `saved'exitassets; 
drop _merge; 



keep death*  HHID PN house* estate* inspay* re* am* per*;


summ;
sort HHID PN; 
sleep 1000;
save `saved'exitassets, replace;
drop _all;


****************************WAVE 4**(1998)**********************************************************;



clear; 

use `wave4d'x98i_nr; // imputation file;


gen temp=real(HHID); 
drop HHID; 
rename temp HHID; 
gen temp=real(PN); 
drop PN; 
rename temp PN; 

gen house4=Q2327X+Q2339X;
gen inspay4=Q2549X;

gen estateflag4=Q2507T; //see comments for a description of the estateflag variable;
*where 1. denotes Legitimate Missing or Partial Interview, 2. Valid Value,3. Closed Bracket;
* 4. Bottom-Open Bracket, 5. Top-Open Bracket, 6. Imputation with no Bracket Information;
*7.Imputed Ownership and amount;

gen deathex4=Q2405X;
gen temp=deathex4;
replace temp=. if deathex4>99995 & deathex4~=.;
drop deathex4;
rename temp deathex4;



********************estate, wave4**************;

desc Q2507X Q2426Z Q2437Z Q2459Z Q2469Z Q2479Z Q2489Z Q2499Z Q2438X;
sum Q2507X Q2426Z Q2437Z Q2459Z Q2469Z Q2479Z Q2489Z Q2499Z Q2438X;

gen estate4=Q2507X;
replace estate4=. if estate4>7500000;
* 1 person reports an estate worth 100 million--do I believe it?;
*Kathryn's comment: Total estate not clear whether includes or does not include house value-but data looks 
*consistent with the waves that made the question more explicit.  Also see Olga's comment for ESTATE above;

gen amspouse4=Q2426Z;//amount to spouse, wave4;
gen amchildren4=Q2437Z; //total amount to children, wave4;
gen perchildren4=Q2438X; //total percentage to children, wave4;
replace perchildren4=. if perchildren4>100;
gen amcharities4=Q2459Z; //amount to charities;
gen amsiblings4=Q2469Z; //amount to siblings;
gen amrelatives4=Q2479Z; //amount to relatives;
gen amfriends4=Q2489Z; //amount to friends;
gen amothers4=Q2499;//amount to others;

sum estate4 am*4 per*4;

gen estatesum4=amspouse4+amchildren4+amcharities4+amsiblings4+amrelatives4+amfriends4+amothers4;


******************************Breakdown of amounts to children**********************************;


desc Q24481Z Q24482Z Q24483Z Q24484Z Q24485Z Q24486Z Q24487Z Q24488Z Q24489Z Q244810Z Q244811Z;            
sum Q24481Z Q24482Z Q24483Z Q24484Z Q24485Z Q24486Z Q24487Z Q24488Z Q24489Z Q244810Z Q244811Z;


gen amchild14=Q24481Z;//amount to child 1, wave4;
gen amchild24=Q24482Z;//amount to child 2, wave4;
gen amchild34=Q24483Z;
replace amchild34=. if amchild34>1000000;

gen amchild44=Q24484Z;
replace amchild44=. if amchild44>1000000;
gen amchild54=Q24485Z; 
gen amchild64=Q24486Z;
gen amchild74=Q24487Z;
gen amchild84=Q24488Z; 
gen amchild94=Q24489Z;
replace amchild94=. if amchild94>1000000;
gen amchild104=Q244810Z;
replace amchild104=. if amchild104>1000000;
gen amchild114=Q244811Z;//amount to child 11, wave4, should be zero!!!;


gen amchildrentot4= amchild14+amchild24+amchild34+amchild44+amchild54+amchild64+amchild74+amchild84+amchild94+amchild104+amchild114;
*two sc amchildrentot4 amchildren4 if (amchildren4<1000000 & amchildrentot4<1000000);
*amchildrentot4 should be somewhat equal to amchildren4;

******************************Breakdown of percentages to children******************************;

desc Q24491X Q24492X Q24493X Q24494X Q24495X Q24496X Q24497X Q24498X Q24499X Q244910X Q244911X; 
sum Q24491X Q24492X Q24493X Q24494X Q24495X Q24496X Q24497X Q24498X Q24499X Q244910X Q244911X;

gen perchild14=Q24491X;
gen perchild24=Q24492X;
gen perchild34=Q24493X;
gen perchild44=Q24494X;
gen perchild54=Q24495X;
gen perchild64=Q24496X;
gen perchild74=Q24497X;
gen perchild84=Q24498X;
gen perchild94=Q24499X;
gen perchild104=Q244910X;
gen perchild114=Q244911X;
gen perchildrentot4=perchild14+perchild24+perchild34+perchild44+perchild54+perchild64+perchild74+perchild84+perchild94+perchild104+perchild114;

sum perchild*4 amchild*4 estate4;

*amchildrentot4 should be somewhat equal to amchildren4, but it's not!;

*stop;


sort HHID PN;
merge HHID PN using `saved'exitassets; 
drop _merge; 


summ;
sort HHID PN; 
sleep 1000;
save `saved'exitassets, replace;
drop _all;
*******************************************************************************************************************;
use `wave4d'X98N_R;// asset file;
gen temp=real(HHID); 
drop HHID; 
rename temp HHID; 
gen temp=real(PN); 
drop PN; 
rename temp PN; 

gen re4=Q2379;
replace re4=0 if re4==. |re4>9000000; 
*there was only 3 responses there must have been no responses to this question;

gen deathins4=Q2411;
gen temp=deathins4;
replace temp=. if deathins4>9990000 & deathins4~=.;
drop deathins4;
rename temp deathins4;


gen housebequeathA4=Q2316;
gen housebequeathB4=Q2335;
gen housebequeathC4=Q2352;
gen housebequeathD4=Q2375;


sort HHID PN;
merge HHID PN using `saved'exitassets; 
drop _merge; 



keep death*  HHID PN house* estate* inspay* re* am* per*;


summ;
sort HHID PN; 
sleep 1000;
save `saved'exitassets, replace;
drop _all;






********************* exit hrs 2000 *********************;
*************************WAVE V**************************;
clear; 
use `wave5d'h2000xi; // imputation file;

gen house5=R2335X+R2347X;
gen estate5=R2514X; // 2 person reports an estate worth 100 million--do I believe it?;
gen estateflag5=R2514T;

*where 1. denotes Legitimate Missing or Partial Interview, 2. Valid Value, 4. Bottom-Open Bracket;
*5. Top-Open Bracket, 6. Imputation with no Bracket Information;

gen inspay5=R2556X;

gen perspouse5= R2434X;
gen amspouse5=.01*perspouse5*estate5;
gen deathex5=R2409X;
gen temp=deathex5;
replace temp=. if deathex5>99995 & deathex5~=.;
drop deathex5;
rename temp deathex5;


keep death*  HHID PN house5 estate* inspay* am* R2335X R2347X; 
gen temp=real(HHID); 
drop HHID; 
rename temp HHID; 
gen temp=real(PN); 
drop PN; 
rename temp PN; 
sort HHID PN; 

summ;

merge HHID PN using `saved'exitassets; 
drop _merge; 

keep death*  HHID PN house* estate* inspay* R2335X R2347X am* per*;

sort HHID PN; 
sleep 1000;
save `saved'exitassets, replace;
clear; 



****************************************************;
use `wave5d'X00N_R; // asset file;
gen temp=real(HHID); 
drop HHID; 
rename temp HHID; 
gen temp=real(PN); 
drop PN; 
rename temp PN; 

gen re5=R2375+R2387;
replace re5=0 if (re5==.|re5>9000000);

gen deathins5=R2418;
gen temp=deathins5;
replace temp=. if deathins5>9990000 & deathins5~=.;
drop deathins5;
rename temp deathins5;

gen housebequeathA5=R2324;
gen housebequeathB5=R2343;
gen housebequeathD5=R2360;
gen housebequeathC5=R2383;
sort HHID PN;
merge HHID PN using `saved'exitassets; 
drop _merge; 

sort HHID PN;
merge HHID PN using `saved'exitassets; 
drop _merge; 



keep death*  HHID PN house* estate* inspay* am* per*;


summ;
sort HHID PN; 
sleep 1000;
save `saved'exitassets, replace;
drop _all;

**********************************Wave VI*********************;
* STILL TO DO: ESTATE FLAGS-- MAKE COMPARABLE TO UP ABOVE     ;
* also, need to track down the question of whether house value is included in the estate;
**************************************************************;

clear; 

***post-exit data***;
use `wave7d'px04T_R;
keep if TPEXITIW==2002;
sort HHID PN;
tempfile temp;
sleep 1000;
save `temp', replace;
********************;

use `wave6d'x02T_R;//data is not imputed;
merge 1:1 HHID PN using `temp';

gen estate1=.;
gen estateflag1=.; 
gen estateflag6=.;

gen housebequeathA1=.;
gen housebequeathB1=.;
gen housebequeathC1=.;
gen housebequeathD1=.;


********************** impute ST107 and ST116 using brackets ***********;

***post-exit***;
replace TPT107=9999998 if TPT107==999998|TPT107==999999;
replace ST107=TPT107 if (ST107==. |ST107>=9999998) & TPT107<999998;
gen bracketflag=1 if (ST108==. & ST109==.)|(ST108==0 & ST109==2000000);
replace ST108=TPT108 if (ST107==. |ST107>=9999998) & TPT108~=. & bracketflag==1;
replace ST109=TPT109 if (ST107==. |ST107>=9999998) & TPT109~=. & bracketflag==1;
drop bracketflag;
replace ST116=TPT116 if (ST116==. |ST116>=9999998) & TPT116<9999998;
gen bracketflag=1 if (ST117==. & ST118==.)|(ST117==0 & ST118==2000000);
replace ST117=TPT117 if (ST116==. |ST116>=9999998) & TPT117~=. & bracketflag==1;
replace ST118=TPT118 if (ST116==. |ST116>=9999998) & TPT118~=. & bracketflag==1;
drop bracketflag;
replace ST107=9999998 if ST107==. & ST108~=.;
replace ST116=9999998 if ST116==. & ST117~=.;
replace ST116=min(ST116, ST107) if ST107~=. & ST116~=.; //discrepency between exit and post-exit in 4 obs;
replace ST107=0 if ST107~=. & ST116~=.;
***************;

replace ST107=0 if ST107==. & ST116~=.;
replace ST116=0 if ST116==. & ST107~=.;
replace ST108=0 if ST108==. & ST117~=.;
replace ST117=0 if ST117==. & ST108~=.;
replace ST109=0 if ST109==. & ST118~=.;
replace ST118=0 if ST118==. & ST109~=.;

replace ST109=9999996 if ST109>9999996 & ST109<.; //to make the point value error code bigger than the max bracket;
replace ST118=9999996 if ST118>9999996 & ST118<.;

gen house6 = ST107 + ST116;

gen mmiss=.;
replace mmiss=0 if house6>-100 & house6<9999998; // donor group;
replace mmiss=1 if house6>9999997 & house6<19999001; // missing variable code;

gen exactvalue=house6;
gen lowervalue= ST108 + ST117;
gen uppervalue= ST109 + ST118;

imputethis;
replace house6=exactvalue;

/*
gen temp=ST107 + ST116;
replace temp=. if (ST107>9999000 & ST107~=.)|(ST116>9999000 & ST116~=.);
replace temp=32000 if ST108==15001 & ST109==49999;
replace temp=50000 if ST108==50000 & ST109==50000;
replace temp=125000 if ST108==50001 & ST109==199999;
replace temp=200000 if ST108==200000 & ST109==200000;
replace temp=1100000 if ST108==200001 & ST109==2000000;
drop ST107;
rename temp ST107;


gen temp=ST116;
replace temp=. if ST116>9999000 & ST116~=.;
replace temp=32000 if ST117==15001 & ST118==49999;
replace temp=50000 if ST117==50000 & ST118==50000;
replace temp=125000 if ST117==50001 & ST118==199999;
replace temp=200000 if ST117==200000 & ST118==200000;
replace temp=1100000  if ST117==200001 & ST118==2000000;
drop ST116;
rename temp ST116;


gen house6=ST107 + ST116;
replace house6=0 if (house6==.|house6>9000000);
*/

replace ST131=. if ST131>9999000 & ST131~=.;
replace ST140=. if ST140>9999000 & ST140~=.;


gen re6=ST131 + ST140;
replace re6=0 if (re6==.|re6>9000000);



********************** impute ST173 using brackets ***********;

***post-exit***;
replace ST173=TPT173 if (ST173==. |ST173>=999999998) & TPT173<9999998;
replace ST173=ECB173 if (ST173==. |ST173>=999999998) & ECB173<999999998;
gen bracketflag1=1 if (ST174==. & ST175==.)|(ST174==0 & ST175==20000000);
replace ST174=TPT174 if (ST173==. |ST173>=999999998) & TPT174~=. & bracketflag==1;
replace ST175=TPT175 if (ST173==. |ST173>=999999998) & TPT175~=. & bracketflag==1;
replace ST173=999999998 if ST173==. & ST174~=.;
drop bracketflag;
***************;

replace estateflag6=2 if (ST173~=. & ST173<999990000);
replace estateflag6=3 if (ST174>0 & ST174<2000001)  & (ST175>0 & ST175<2000001);
replace estateflag6=4 if ST174==0 & ST175<2000001 & ST175~=.;
replace estateflag6=5 if ST174>0 & ST174~=. & ST175>2000000 & ST175~=.;
replace estateflag6=6 if ST174 == 0 & ST175 > 2000000;
replace estateflag6=1 if estateflag6==. & ST173>999990000;

gen mmiss=.;
replace mmiss=0 if ST173>-100 & ST173<999999991; // donor group;
replace mmiss=1 if ST173>999999990 & ST173<1999900001; // missing variable code;

replace exactvalue=ST173;
replace lowervalue=ST174;
replace uppervalue=ST175;

imputethis;
gen estate6=exactvalue;

replace TPT242=ECBHOME if TPT242==.|TPT242==8|TPT242==9;
replace estate6=estate6+house6 if TPT242==5;


/*
tab ST174 ST175;
gen guess = 0;
replace guess = 1 if ST174 == 0 & ST175 > 2000000;
sum ST173 ST174 ST175;
gen impute=0;
replace impute=1 if (ST173==.|ST173>999990000); 
replace ST173=0 if (ST173==.|ST173>999990000); 
egen mymin=min(ST175/5) if (ST175~=0 & ST175~=.);
egen mymax=max(ST174) if ST174~=.;
replace ST174=mymin if ST174==0; drop mymin;
replace ST175=mymax if ST175>2000000 & ST175~=.; drop mymax;
replace ST173=sqrt(ST174*ST175) if (ST174~=. & ST175~=.);
replace ST173 = 210777.1  if guess == 1;
sort impute;
by impute: sum ST173 ST174 ST175;
sort guess;
by guess: sum ST173 ST174 ST175 if impute==1;
*/



********************** impute ST186 using brackets ***********;
replace ST188=999000 if ST188>9999000 & ST188<99999999999; // this makes missing value code bigger than max range value -- need this for imputations;

replace ST187=0 if ST187==. & ST186==9999998;      // fix annoying quirk in data;
replace ST188=999000 if ST188==. & ST186==9999998;  // fix annoying quirk in data;

gen mmiss=.;
replace mmiss=0 if ST186>-100 & ST186<9999991; // donor group;
replace mmiss=1 if ST186>9999990 & ST186<19999001; // missing variable code;

replace exactvalue=ST186;
replace lowervalue=ST187;
replace uppervalue=ST188;

imputethis;
replace ST186=exactvalue;

gen inspay6=ST186;

/*
tab ST187 ST188;
gen guess = 0;
replace guess = 1 if ST187 == 0 & ST188 > 2000000;
sum ST186 ST187 ST188;
gen impute=0;
replace impute=1 if (ST186==.|ST186>9999000); 
replace ST186=0 if (ST186==.|ST186>9999000); 
egen mymin=min(ST188/5) if (ST188~=0 & ST188~=.);
egen mymax=max(ST187) if ST187~=.;
replace ST187=mymin if ST187==0; drop mymin;
replace ST188=mymax if ST188>mymax & ST188~=.; drop mymax;
replace ST186=sqrt(ST187*ST188) if (ST187~=. & ST188~=.);
replace ST186 = 22660  if guess == 1;
sort impute;
by impute: sum ST186 ST187 ST188;
sort guess;
by guess: sum ST186 ST187 ST188 if impute==1;
drop guess impute;
*/

********************** impute ST148 using brackets ***********;

***post-exit***;
replace ST148=TPT148 if ST148==. & TPT148<999998;
gen bracketflag=1 if (ST149==. & ST150==.)|(ST149==0 & ST150==1000000);
replace ST149=TPT149 if ST148==. & TPT149~=. & bracketflag==1;
replace ST150=TPT150 if ST148==. & TPT150~=. & bracketflag==1;
replace ST148=9999998 if ST148==.; //error code not in data for some reason
drop bracketflag;
***************;

gen mmiss=.;
replace mmiss=0 if ST148>-100 & ST148<9999991; // donor group;
replace mmiss=1 if ST148>9999990 & ST148<19999001; // missing variable code;

replace exactvalue=ST148;
replace lowervalue=ST149;
replace uppervalue=ST150;

imputethis;
gen deathex6=exactvalue;

/*
tab ST149 ST150;
gen guess = 0;
replace guess = 1 if ST149 == 0 & ST150 > 200000;
sum ST148 ST149 ST150;
gen impute=0;
replace impute=1 if (ST148==.|ST148>9999000); 
replace ST148=0 if (ST148==.|ST148>9999000); 
egen mymin=min(ST150/5) if (ST150~=0 & ST150~=.);
egen mymax=max(ST149) if ST149~=.;
replace ST149=mymin if ST149==0; drop mymin;
replace ST150=mymax if ST150>mymax & ST150~=.; drop mymax;
replace ST148=sqrt(ST149*ST150) if (ST149~=. & ST150~=.);
replace ST148 = 6902 if guess == 1;
sort impute;
by impute: sum ST148 ST149 ST150;
sort guess;
by guess: sum ST148 ST149 ST150 if impute==1;
drop guess impute;
*/

********************** impute amspouse6 using brackets ***********;

gen amspouse6=ST9002 if ST9002<9999998;
replace amspouse6=estate6*ST9003/100 if amspouse6==. & ST9003<101;
replace amspouse6=TPT9002 if TPT9002<9999998 & amspouse6==.;
replace amspouse6=estate6*TPT9003/100 if amspouse6==. & TPT9003<101;
replace amspouse6=estate6 if amspouse6==100;

replace ST9004=TPT9004 if TPT9004~=. & (ST9004==.|ST9004==8|ST9004==9) & ST9005==. & ST9006==. & ST9007==. & ST9008==.;
replace ST9005=TPT9005 if TPT9005~=. & ST9004==1 & (ST9005==.|ST9005==8|ST9005==9) & ST9006==. & ST9007==. & ST9008==.; 
replace ST9006=TPT9006 if TPT9006~=. & ST9004==1 & ST9005==1 & (ST9006==.|ST9006==8|ST9007==9) & ST9007==. & ST9008==.;
replace ST9007=TPT9007 if TPT9007~=. & ST9004==5 & (ST9007==.|ST9007==8|ST9007==9) & ST9005==. & ST9006==. & ST9008==.;
replace ST9008=TPT9008 if TPT9008~=. & ST9004==5 & ST9007==5 & (ST9008==.|ST9008==8|ST9008==9) & ST9005==. & ST9006==.;


drop lowervalue uppervalue;
replace exactvalue=amspouse6/estate6*100;
replace exactvalue=100 if exactvalue>100 & exactvalue<.;

gen lowervalue=50 if ST9004==1;
gen uppervalue=50 if ST9004==5;
replace lowervalue=75 if ST9005==1;
replace uppervalue=75 if ST9005==5;
replace lowervalue=90 if ST9006==1;
replace uppervalue=90 if ST9006==5;
replace lowervalue=25 if ST9007==1;
replace uppervalue=25 if ST9007==5;
replace lowervalue=10 if ST9008==1;
replace uppervalue=10 if ST9008==5;
replace lowervalue=0 if ST9008==5;
replace uppervalue=100 if ST9006==1;

replace lowervalue=0 if (lowervalue==. & uppervalue~=.)|(ST9004==8|ST9004==9);
replace uppervalue=100 if (lowervalue~=. & uppervalue==.)|(ST9004==8|ST9004==9);

replace exactvalue=998 if exactvalue==. & lowervalue~=.;

gen mmiss=.;
replace mmiss=0 if exactvalue>-1 & exactvalue<101; // donor group;
replace mmiss=1 if exactvalue>100 & exactvalue<9999; // missing variable code;

imputethis;
replace amspouse6=estate6*exactvalue/100;





gen deathins6=ST153;
gen temp=deathins6;
replace temp=. if deathins6>9990000 & deathins6~=.;
drop deathins6;
rename temp deathins6;


gen housebequeathA6=ST102;
gen housebequeathB6=ST111;
gen housebequeathC6=ST126;
gen housebequeathD6=ST135;


keep death*  HHID PN house* estate* inspay* re* HHID PN housebeq* house* estate* inspay* deathex* amsp* ST107 ST116;
gen temp=real(HHID); 
drop HHID; 
rename temp HHID; 
gen temp=real(PN); 
drop PN; 
rename temp PN; 
sort HHID PN; 

sort HHID PN;
merge HHID PN using `saved'exitassets; 
drop _merge; 

summ  HHID PN death* estate* inspay* re* HHID PN  house* estate* ins*  ;
keep   HHID PN death* estate* inspay* re* HHID PN  house* estate* ins* amsp* ;




sort HHID PN; 
save `saved'exitassets, replace;
drop _all;






**********************************Wave VII*********************,
clear; 

***post-exit data***;
use `wave8d'px06T_R;
keep if UPEXITIW==2004;
sort HHID PN;
tempfile temp;
sleep 1000;
save `temp', replace;
********************; 

use `wave7d'x04T_R, clear;//data is not imputed;
merge 1:1 HHID PN using `temp';

gen estate1=.;
gen estateflag1=.; 
gen estateflag7=.;
*Jon: I added the following astericks because the variables are never used.
*gen housebequeathA1=.;
*gen housebequeathB1=.;
*gen housebequeathC1=.;
*gen housebequeathD1=.;

********************** impute TT107 and TT116 using brackets ***********;

***post-exit***;
replace TT116=UPT116 if (TT116==. |TT116>=9999998) & UPT116<9999998;
gen bracketflag=1 if (TT117==. & TT118==.)|(TT117==0 & TT118==99999996);
replace TT117=UPT117 if (TT116==. |TT116>=9999998) & UPT117~=. & bracketflag==1;
replace TT118=UPT118 if (TT116==. |TT116>=9999998) & UPT118~=. & bracketflag==1;
drop bracketflag;
replace TT107=9999998 if TT107==. & TT108~=.;
replace TT116=9999998 if TT116==. & TT117~=.;
***************;

replace TT107=0 if TT107==. & TT116~=.;
replace TT116=0 if TT116==. & TT107~=.;
replace TT108=0 if TT108==. & TT117~=.;
replace TT117=0 if TT117==. & TT108~=.;
replace TT109=0 if TT109==. & TT118~=.;
replace TT118=0 if TT118==. & TT109~=.;

replace TT107=9999998 if TT107==999998;
replace TT107=9999999 if TT107==999999;

gen house7 = TT107 + TT116;

replace TT109= 9999990 if TT109>99999000 & TT109<99999999999; // this makes missing value code bigger than max range value -- need this for imputations;
replace TT118= 9999990 if TT118>99999000 & TT118<99999999999;


gen mmiss=.;
replace mmiss=0 if house7>-100 & house7<9999991; // donor group;
replace mmiss=1 if house7>9999990 & house7<19999001; // missing variable code;

gen exactvalue=house7;
gen lowervalue= TT108 + TT117;
gen uppervalue= TT109 + TT118;

imputethis;
replace house7=exactvalue;

/*
replace TT107=0 if TT107==. & TT116~=.;
replace TT116=0 if TT116==. & TT107~=.;


gen temp=TT107;
replace temp=. if TT107>9999000 & TT107~=.;
replace temp=32000 if TT108==15001 & TT109==49999;
replace temp=50000 if TT108==50000 & TT109==50000;
replace temp=125000 if TT108==50001 & TT109==199999;
replace temp=200000 if TT108==200000 & TT109==200000;
replace temp=1100000 if TT108==200001 & TT109==2000000;
drop TT107;
rename temp TT107;


gen temp=TT116;
replace temp=. if TT116>9999000 & TT116~=.;
replace temp=32000 if TT117==15001 & TT118==49999;
replace temp=50000 if TT117==50000 & TT118==50000;
replace temp=125000 if TT117==50001 & TT118==199999;
replace temp=200000 if TT117==200000 & TT118==200000;
replace temp=1100000  if TT117==200001 & TT118==2000000;
drop TT116;
rename temp TT116;


gen house7=TT107 + TT116;
replace house7=0 if (house7==.|house7>9000000);
*/

replace TT131=. if TT131>999990 & TT131~=.;
replace TT140=. if TT140>999990 & TT140~=.;


gen re7=TT131 + TT140;
replace re7=0 if (re7==.|re7>9000000);


********************** impute TT173 using brackets ***********;

***post-exit***;
replace TT173=UPT173 if (TT173==. |TT173>=999999998) & UPT173<9999999998;
gen bracketflag1=1 if (TT174==. & TT175==.)|(TT174==0 & TT175==99999996);
replace TT174=UPT174 if (TT173==. |TT173>=999999998) & UPT174~=. & bracketflag==1;
replace TT175=UPT175 if (TT173==. |TT173>=999999998) & UPT175~=. & bracketflag==1;
replace TT173=999999998 if TT173==. & TT174~=.;
drop bracketflag;
***************;

replace estateflag7=2 if (TT173~=. & TT173<999990000);
replace estateflag7=3 if (TT174>0 & TT174<2000001)  & (TT175>0 & TT175<2000001);
replace estateflag7=4 if TT174==0 & TT175<2000001 & TT175~=.;
replace estateflag7=5 if TT174>0 & TT174~=. & TT175>2000000 & TT175~=.;
replace estateflag7=6 if TT174 == 0 & TT175 > 2000000;
replace estateflag7=1 if estateflag7==. & TT173>999990000;


replace TT174=0 if TT174==. & (TT173==999999998|TT173==999999998);      //fix annoying quirk in data;
replace TT175=99999996 if TT175==. & (TT173==999999998|TT173==999999998);  // fix annoying quirk in data;

gen mmiss=.;
replace mmiss=0 if TT173>-100 & TT173<999999990; // donor group;
replace mmiss=1 if TT173>999999990 & TT173<1999999991; // missing variable code;

replace exactvalue=TT173;
replace lowervalue=TT174;
replace uppervalue=TT175;

imputethis;
gen estate7=exactvalue;

replace TT242=UPT242 if TT242==.|TT242==8|TT242==9;
replace estate7=estate7+house7 if TT242==5;

/*
tab TT174 TT175;
gen guess = 0;
replace guess = 1 if TT174 == 0 & TT175 > 2000000;
sum TT173 TT174 TT175;
gen impute=0;
replace impute=1 if (TT173==.|TT173>999990000); 
replace TT173=0 if (TT173==.|TT173>999990000); 
egen mymin=min(TT175/5) if (TT175~=0 & TT175~=.);
egen mymax=max(TT174) if TT174~=.;
replace TT174=mymin if TT174==0; drop mymin;
replace TT175=mymax if TT175>2000000 & TT175~=.; drop mymax;
replace TT173=sqrt(TT174*TT175) if (TT174~=. & TT175~=.);
replace TT173 = 221087.1  if guess == 1; *Phil: I used the mean minus the top 2 guys;
sort impute;
by impute: sum TT173 TT174 TT175;
sort guess;
by guess: sum TT173 TT174 TT175 if impute==1;
drop guess impute;
*/

********************** impute TT186 using brackets ***********;
replace TT188=999990 if TT188>99999990 & TT188<99999999999; // this makes missing value code bigger than max range value -- need this for imputations;

replace TT187=0 if TT187==. & TT186==999998;      //fix annoying quirk in data;
replace TT188=999990 if TT188==. & TT186==999998;  // fix annoying quirk in data;

gen mmiss=.;
replace mmiss=0 if TT186>-100 & TT186<999990; // donor group;
replace mmiss=1 if TT186>999990 & TT186<1999991; // missing variable code;

replace exactvalue=TT186;
replace lowervalue=TT187;
replace uppervalue=TT188;

imputethis;
gen inspay7=exactvalue;

/*
tab TT187 TT188;
gen guess = 0;
replace guess = 1 if TT187 == 0 & TT188 > 100000;
sum TT186 TT187 TT188;
gen impute=0;
replace impute=1 if (TT186==.|TT186>999900); 
replace TT186=0 if (TT186==.|TT186>999900); 
egen mymin=min(TT188/5) if (TT188~=0 & TT188~=.);
egen mymax=max(TT187) if TT187~=.;
replace TT187=mymin if TT187==0; drop mymin;
replace TT188=mymax if TT188>mymax & TT188~=.; drop mymax;
replace TT186=sqrt(TT187*TT188) if (TT187~=. & TT188~=.);
replace TT186 = 17856  if guess == 1;
sort impute;
by impute: sum TT186 TT187 TT188;
sort guess;
by guess: sum TT186 TT187 TT188 if impute==1;
drop guess impute;
*/
 
********************** impute TT148 using brackets ***********;

replace TT148=999996 if TT148==99996;
replace TT148=999998 if TT148==99998;
replace TT148=999999 if TT148==99999;

replace TT150=99999 if TT150>99999 & TT150<99999999999; // this makes missing value code bigger than max range value -- need this for imputations;

replace TT149=0 if TT149==. & TT148>999990 & TT148<9999999999;      //fix annoying quirk in data;
replace TT150=99999 if TT150==. & TT148>999990 & TT148<9999999999;  // fix annoying quirk in data;

gen mmiss=.;
replace mmiss=0 if TT148>-100 & TT148<99990; // donor group;
replace mmiss=1 if TT148>99990 & TT148<1999991; // missing variable code;

replace exactvalue=TT148;
replace lowervalue=TT149;
replace uppervalue=TT150;

imputethis;
gen deathex7=exactvalue;

/*
tab TT149 TT150;
gen guess = 0;
replace guess = 1 if TT149 == 0 & TT150 > 25000;
sum TT148 TT149 TT150;
gen impute=0;
replace impute=1 if (TT148==.|TT148>99990); 
replace TT148=0 if (TT148==.|TT148>99990); 
egen mymin=min(TT150/5) if (TT150~=0 & TT150~=.);
egen mymax=max(TT149) if TT149~=.;
replace TT149=mymin if TT149==0; drop mymin;
replace TT150=mymax if TT150>mymax & TT150~=.; drop mymax;
replace TT148=sqrt(TT149*TT150) if (TT149~=. & TT150~=.);
replace TT148 = 6973 if guess == 1;
sort impute;
by impute: sum TT148 TT149 TT150;
sort guess;
by guess: sum TT148 TT149 TT150 if impute==1;
drop guess impute;
*/

********************** impute amspouse7 using brackets ***********;

gen amspouse7=TT9002 if TT9002<9999998;
replace amspouse7=estate7*TT9003/100 if amspouse7==. & TT9003<101;
replace amspouse7=UPT9002 if UPT9002<9999998 & amspouse7==.;
replace amspouse7=estate7*UPT9003/100 if amspouse7==. & UPT9003<101;
replace amspouse7=estate7 if amspouse7==100;

replace TT9004=UPT9004 if UPT9004~=. & (TT9004==.|TT9004==8|TT9004==9) & TT9005==. & TT9006==. & TT9007==. & TT9008==.;
replace TT9005=UPT9005 if UPT9005~=. & TT9004==1 & (TT9005==.|TT9005==8|TT9005==9) & TT9006==. & TT9007==. & TT9008==.; 
replace TT9006=UPT9006 if UPT9006~=. & TT9004==1 & TT9005==1 & (TT9006==.|TT9006==8|TT9007==9) & TT9007==. & TT9008==.;
replace TT9007=UPT9007 if UPT9007~=. & TT9004==5 & (TT9007==.|TT9007==8|TT9007==9) & TT9005==. & TT9006==. & TT9008==.;
replace TT9008=UPT9008 if UPT9008~=. & TT9004==5 & TT9007==5 & (TT9008==.|TT9008==8|TT9008==9) & TT9005==. & TT9006==.;


drop lowervalue uppervalue;
replace exactvalue=amspouse7/estate7*100;
replace exactvalue=100 if exactvalue>100 & exactvalue<.;

gen lowervalue=50 if TT9004==1;
gen uppervalue=50 if TT9004==5;
replace lowervalue=75 if TT9005==1;
replace uppervalue=75 if TT9005==5;
replace lowervalue=90 if TT9006==1;
replace uppervalue=90 if TT9006==5;
replace lowervalue=25 if TT9007==1;
replace uppervalue=25 if TT9007==5;
replace lowervalue=10 if TT9008==1;
replace uppervalue=10 if TT9008==5;
replace lowervalue=0 if TT9008==5;
replace uppervalue=100 if TT9006==1;

replace lowervalue=0 if (lowervalue==. & uppervalue~=.)|(TT9004==8|TT9004==9);
replace uppervalue=100 if (lowervalue~=. & uppervalue==.)|(TT9004==8|TT9004==9);

replace exactvalue=998 if exactvalue==. & lowervalue~=.;

gen mmiss=.;
replace mmiss=0 if exactvalue>-1 & exactvalue<101; // donor group;
replace mmiss=1 if exactvalue>100 & exactvalue<9999; // missing variable code;

imputethis;
replace amspouse7=estate7*exactvalue/100;





gen deathins7=TT153;
gen temp=deathins7;
replace temp=. if deathins7> 99990 & deathins7~=.;
drop deathins7;
rename temp deathins7;



gen housebequeathA7=TT102;
gen housebequeathB7=TT111;
*gen housebequeathC7=TT126; * PHIL: I can't find this one;
gen housebequeathD7=TT135;


keep death*  HHID PN house* estate* inspay* re* HHID PN housebeq* house* estate* inspay* deathex* amsp* TT107 TT116;
gen temp=real(HHID); 
drop HHID; 
rename temp HHID; 
gen temp=real(PN); 
drop PN; 
rename temp PN; 
sort HHID PN; 

sort HHID PN;
merge HHID PN using `saved'exitassets; 
drop _merge; 

summ  HHID PN death* estate* inspay* re* HHID PN  house* estate* ins*  ;
keep   HHID PN death* estate* inspay* re* HHID PN  house* estate* ins* amsp* ;


sort HHID PN; 
sleep 1000;
save `saved'exitassets, replace;

drop _all;





*************JON DAVIS WORK BEGINS HERE****************



**********************************Wave VIII*********************,
clear; 
***post-exit data***;
use `wave9d'px08T_R;
keep if VPEXITIW==2006;
sort HHID PN;
tempfile temp;
save `temp', replace;
********************; 

use `wave8d'x06T_R, clear;//data is not imputed;
merge 1:1 HHID PN using `temp';

gen estate1=.;
gen estateflag1=.; 
gen estateflag8=.;
*gen housebequeathA1=.;
*gen housebequeathB1=.;
*gen housebequeathC1=.;
*gen housebequeathD1=.;

********************** impute UT107 and UT116 using brackets ***********;

***post-exit***;
replace UT116=VPT116 if (UT116==. |UT116>=9999998) & VPT116<9999998;
gen bracketflag=1 if (UT117==. & UT118==.)|(UT117==0 & UT118==99999996);
replace UT117=VPT117 if (UT116==. |UT116>=9999998) & VPT117~=. & bracketflag==1;
replace UT118=VPT118 if (UT116==. |UT116>=9999998) & VPT118~=. & bracketflag==1;
drop bracketflag;
replace UT107=9999998 if UT107==. & UT108~=.;
replace UT116=9999998 if UT116==. & UT117~=.;
***************;


replace UT107=0 if UT107==. & UT116~=.;
replace UT116=0 if UT116==. & UT107~=.;
replace UT108=0 if UT108==. & UT117~=.;
replace UT117=0 if UT117==. & UT108~=.;
replace UT109=0 if UT109==. & UT118~=.;
replace UT118=0 if UT118==. & UT109~=.;

gen house8 = UT107 + UT116;

replace UT109= 9999990 if UT109>99999000 & UT109<99999999999; // this makes missing value code bigger than max range value -- need this for imputations;
replace UT118= 9999990 if UT118>99999000 & UT118<99999999999;


gen mmiss=.;
replace mmiss=0 if house8>-100 & house8<9999991; // donor group;
replace mmiss=1 if house8>9999990 & house8<19999001; // missing variable code;

gen exactvalue=house8;
gen lowervalue= UT108 + UT117;
gen uppervalue= UT109 + UT118;

imputethis;
replace house8=exactvalue;



/*
replace UT107=0 if UT107==. & UT116~=.;
replace UT116=0 if UT116==. & UT107~=.;

gen temp=UT107;
replace temp=. if UT107>9999000 & UT107~=.;
replace temp=32000 if UT108==15001 & UT109==49999;
replace temp=50000 if UT108==50000 & UT109==50000;
replace temp=125000 if UT108==50001 & UT109==199999;
replace temp=200000 if UT108==200000 & UT109==200000;
replace temp=1100000 if UT108==200001 & UT109==2000000;
drop UT107;
rename temp UT107;


gen temp=UT116;
replace temp=. if UT116>9999000 & UT116~=.;
replace temp=32000 if UT117==15001 & UT118==49999;
replace temp=50000 if UT117==50000 & UT118==50000;
replace temp=125000 if UT117==50001 & UT118==199999;
replace temp=200000 if UT117==200000 & UT118==200000;
replace temp=1100000  if UT117==200001 & UT118==2000000;
drop UT116;
rename temp UT116;


gen house8=UT107 + UT116;
replace house8=0 if (house8==.|house8>9000000);
**/

replace UT131=. if UT131>9999000 & UT131~=.;
replace UT140=. if UT140>9999000 & UT140~=.;


gen re8=UT131 + UT140;
replace re8=0 if (re8==.|re8>9000000);



********************** impute UT173 using brackets ***********;

replace UT173=9999999998 if UT174~=. & UT175~=.; //fix data problem

***post-exit***;
replace UT173=VPT173 if (UT173==. |UT173>=9999999998) & VPT173<9999999998;
gen bracketflag1=1 if (UT174==. & UT175==.)|(UT174==0 & UT175==99999996);
replace UT174=VPT174 if (UT173==. |UT173>=9999999998) & VPT174~=. & bracketflag==1;
replace UT175=VPT175 if (UT173==. |UT173>=9999999998) & VPT175~=. & bracketflag==1;
replace UT173=9999999998 if UT173==. & UT174~=.;
drop bracketflag;
***************;

replace estateflag8=2 if (UT173~=. & UT173<9999990000);
replace estateflag8=3 if (UT174>0 & UT174<2000001)  & (UT175>0 & UT175<2000001);
replace estateflag8=4 if UT174==0 & UT175<2000001 & UT175~=.;
replace estateflag8=5 if UT174>0 & UT174~=. & UT175>2000000 & UT175~=.;
replace estateflag8=6 if UT174 == 0 & UT175 > 2000000;
replace estateflag8=1 if estateflag8==. & UT173>9999990000;


replace UT174=0 if UT174==. & (UT173==9999999998|UT173==9999999999);      //fix annoying quirk in data;
replace UT175=99999996 if UT175==. & (UT173==9999999998|UT173==9999999999);  // fix annoying quirk in data;

gen mmiss=.;
replace mmiss=0 if UT173>-100 & UT173<9999999990; // donor group;
replace mmiss=1 if UT173>9999999990 & UT173<19999999991; // missing variable code;

replace exactvalue=UT173;
replace lowervalue=UT174;
replace uppervalue=UT175;

imputethis;
gen estate8=exactvalue;

replace UT242=VPT242 if UT242==.|UT242==8|UT242==9;
replace estate8=estate8+house8 if UT242==5;


/*
tab UT174 UT175;
gen guess = 0;
replace guess = 1 if UT174 == 0 & UT175 > 2000000;
sum UT173 UT174 UT175;
gen impute=0;
replace impute=1 if (UT173==.|UT173>999990000);
replace UT173=0 if (UT173==.|UT173>999990000);
egen mymin = min(UT175/5) if (UT175~=0 & UT175~=.);
egen mymax = max(UT174) if UT174~=.;
replace UT174 = mymin if UT174==0;
drop mymin;
replace UT175=mymax if UT175>2000000 & UT175~=.; 
drop mymax;
replace UT173=sqrt(UT174*UT175) if (UT174~=. & UT175~=.);
replace UT173 = 370485.6  if guess == 1; 
*Jon: I used the mean of all the observations.;
sort impute;
by impute: sum UT173 UT174 UT175;
sort guess;
by guess: sum UT173 UT174 UT175 if impute==1;
drop guess impute;

gen estate8=UT173;
*/

********************** impute UT186 using brackets ***********;

replace UT188=9999990 if UT188>99999990 & UT188<99999999999; // this makes missing value code bigger than max range value -- need this for imputations;

replace UT187=0 if UT187==. & UT186==9999998;      //fix annoying quirk in data;
replace UT188=9999990 if UT188==. & UT186==9999998;  // fix annoying quirk in data;

gen mmiss=.;
replace mmiss=0 if UT186>-100 & UT186<9999990; // donor group;
replace mmiss=1 if UT186>9999990 & UT186<19999991; // missing variable code;

replace exactvalue=UT186;
replace lowervalue=UT187;
replace uppervalue=UT188;

imputethis;
gen inspay8=exactvalue;

/*
tab UT187 UT188;
gen guess = 0;
replace guess = 1 if UT187 == 0 & UT188 > 100000;
sum UT186 UT187 UT188;
gen impute=0;
replace impute=1 if (UT186==.|UT186>9999900);
replace UT186=0 if (UT186==.|UT186>9999900);
egen mymin=min(UT188/5) if (UT188~=0 & UT188~=.);
egen mymax=max(UT187) if UT187~=.;
replace UT187=mymin if UT187==0;
drop mymin;
replace UT188=mymax if UT188>mymax & UT188~=.;
drop mymax;
replace UT186=sqrt(UT187*UT188) if (UT187~=. & UT188~=.);
replace UT186 = 15617  if guess == 1; //Jon: I used the mean minus any observations that were of the form 999999x;
sort impute;
by impute: sum UT186 UT187 UT188;
sort guess;
by guess: sum UT186 UT187 UT188 if impute==1;
drop guess impute;

gen inspay8=UT186;
*/


********************** impute UT148 using brackets ***********;
replace UT148=9999999998 if UT148==.; //fix data issue

replace UT149=0 if UT149==. & UT148>9999999990 & UT148<99999999999;      //fix annoying quirk in data;
replace UT150=99999996 if UT150==. & UT148>9999999990 & UT148<99999999999;  // fix annoying quirk in data;

gen mmiss=.;
replace mmiss=0 if UT148>-100 & UT148<9999999990; // donor group;
replace mmiss=1 if UT148>9999999990 & UT148<19999999991; // missing variable code;

replace exactvalue=UT148;
replace lowervalue=UT149;
replace uppervalue=UT150;

imputethis;
gen deathex8=exactvalue;

/*
tab UT149 UT150;
gen guess = 0;
replace guess = 1 if UT149 == 0 & UT150 > 25000;
sum UT148 UT149 UT150;
gen impute=0;
replace impute=1 if (UT148==.|UT148>99990);
replace UT148=0 if (UT148==.|UT148>99990);
egen mymin=min(UT150/5) if (UT150~=0 & UT150~=.);
egen mymax=max(UT149) if UT149~=.;
replace UT149=mymin if UT149==0;  
drop mymin;
replace UT150=mymax if UT150>mymax & UT150~=.;
drop mymax;
replace UT148=sqrt(UT149*UT150) if (UT149~=. & UT150~=.);
replace UT148 = 7142 if guess == 1;
sort impute;
by impute: sum UT148 UT149 UT150;
sort guess;
by guess: sum UT148 UT149 UT150 if impute==1;
drop guess impute;

gen deathex8=UT148;
*/


********************** impute amspouse8 using brackets ***********;

gen amspouse8=UT9002 if UT9002<9999998;
replace amspouse8=estate8*UT9003/100 if amspouse8==. & UT9003<101;
replace amspouse8=VPT9002 if VPT9002<9999998 & amspouse8==.;
replace amspouse8=estate8*VPT9003/100 if amspouse8==. & VPT9003<101;
replace amspouse8=estate8 if amspouse8==100;

replace UT9004=VPT9004 if VPT9004~=. & (UT9004==.|UT9004==8|UT9004==9) & UT9005==. & UT9006==. & UT9007==. & UT9008==.;
replace UT9005=VPT9005 if VPT9005~=. & UT9004==1 & (UT9005==.|UT9005==8|UT9005==9) & UT9006==. & UT9007==. & UT9008==.; 
replace UT9006=VPT9006 if VPT9006~=. & UT9004==1 & UT9005==1 & (UT9006==.|UT9006==8|UT9007==9) & UT9007==. & UT9008==.;
replace UT9007=VPT9007 if VPT9007~=. & UT9004==5 & (UT9007==.|UT9007==8|UT9007==9) & UT9005==. & UT9006==. & UT9008==.;
replace UT9008=VPT9008 if VPT9008~=. & UT9004==5 & UT9007==5 & (UT9008==.|UT9008==8|UT9008==9) & UT9005==. & UT9006==.;


drop lowervalue uppervalue;
replace exactvalue=amspouse8/estate8*100;
replace exactvalue=100 if exactvalue>100 & exactvalue<.;

gen lowervalue=50 if UT9004==1;
gen uppervalue=50 if UT9004==5;
replace lowervalue=75 if UT9005==1;
replace uppervalue=75 if UT9005==5;
replace lowervalue=90 if UT9006==1;
replace uppervalue=90 if UT9006==5;
replace lowervalue=25 if UT9007==1;
replace uppervalue=25 if UT9007==5;
replace lowervalue=10 if UT9008==1;
replace uppervalue=10 if UT9008==5;
replace lowervalue=0 if UT9008==5;
replace uppervalue=100 if UT9006==1;

replace lowervalue=0 if (lowervalue==. & uppervalue~=.)|(UT9004==8|UT9004==9);
replace uppervalue=100 if (lowervalue~=. & uppervalue==.)|(UT9004==8|UT9004==9);

replace exactvalue=998 if exactvalue==. & lowervalue~=.;

gen mmiss=.;
replace mmiss=0 if exactvalue>-1 & exactvalue<101; // donor group;
replace mmiss=1 if exactvalue>100 & exactvalue<9999; // missing variable code;

imputethis;
replace amspouse8=estate8*exactvalue/100;


gen deathins8=UT153;
gen temp=deathins8;
replace temp=. if deathins8>9990000 & deathins8~=.;
drop deathins8;
rename temp deathins8;



gen housebequeathA8=UT102;
gen housebequeathB8=UT111;
*gen housebequeathC8=UT126;  
* PHIL: I can't find this one *JON: (Neither can I);
gen housebequeathD8=UT135;


keep death*  HHID PN house* estate* inspay* re* HHID PN housebeq* house* estate* inspay* deathex* amsp* UT107 UT116;
gen temp=real(HHID);
drop HHID;
rename temp HHID;
gen temp=real(PN);
drop PN;
rename temp PN;
sort HHID PN;

sort HHID PN;
merge HHID PN using `saved'exitassets;
drop _merge;

summ  HHID PN death* estate* inspay* re* HHID PN  house* estate* ins*;
keep   HHID PN death* estate* inspay* re* HHID PN  house* estate* ins* amsp*;  


sort HHID PN;
save `saved'exitassets, replace;

drop _all;

**********************************Wave IX*********************,
clear; 
***post-exit data***;
use `wave10d'px10T_R;
keep if WPEXITIW==2008;
sort HHID PN;
tempfile temp;
save `temp', replace;
********************; 

use `wave9d'x08T_R, clear;//data is not imputed;
merge 1:1 HHID PN using `temp'; 


gen estateflag9=.;
*gen housebequeathA1=.;
*gen housebequeathB1=.;
*gen housebequeathC1=.;
*gen housebequeathD1=.;

********************** impute VT107 and VT116 using brackets ***********;

***post-exit***;
replace VT107=WPT107 if (VT107==. |VT107>=9999998) & WPT107<9999998;
replace VT116=WPT116 if (VT116==. |VT116>=9999998) & WPT116<9999998;
gen bracketflag=1 if (VT117==. & VT118==.)|(VT117==0 & VT118==99999996);
replace VT117=WPT117 if (VT116==. |VT116>=9999998) & WPT117~=. & bracketflag==1;
replace VT118=WPT118 if (VT116==. |VT116>=9999998) & WPT118~=. & bracketflag==1;
drop bracketflag;
replace VT107=9999998 if VT107==. & VT108~=.;
replace VT116=9999998 if VT116==. & VT117~=.;
***************;

replace VT107=0 if VT107==. & VT116~=.;
replace VT116=0 if VT116==. & VT107~=.;
replace VT108=0 if VT108==. & VT117~=.;
replace VT117=0 if VT117==. & VT108~=.;
replace VT109=0 if VT109==. & VT118~=.;
replace VT118=0 if VT118==. & VT109~=.;

gen house9 = VT107 + VT116;

replace VT109= 9999990 if VT109>99999000 & VT109<99999999999; // this makes missing value code bigger than max range value -- need this for imputations;
replace VT118= 9999990 if VT118>99999000 & VT118<99999999999;


gen mmiss=.;
replace mmiss=0 if house9>-100 & house9<9999991; // donor group;
replace mmiss=1 if house9>9999990 & house9<19999001; // missing variable code;


gen lowervalue= VT108 + VT117;
gen uppervalue= VT109 + VT118;

replace lowervalue=0 if lowervalue==. & (house9==9999998|house9==9999999);      //fix annoying quirk in data;
replace uppervalue=99999996 if uppervalue==. & (house9==9999998|house9==9999999);  // fix annoying quirk in data;

gen exactvalue=house9;

imputethis;
replace house9=exactvalue;

/*
replace VT107=0 if VT107==. & VT116~=.;
replace VT116=0 if VT116==. & VT107~=.;

gen temp=VT107;
replace temp=. if VT107>9999000 & VT107~=.;
replace temp=32000 if VT108==15001 & VT109==49999;
replace temp=50000 if VT108==50000 & VT109==50000;
replace temp=125000 if VT108==50001 & VT109==199999;
replace temp=200000 if VT108==200000 & VT109==200000;
replace temp=1100000 if VT108==200001 & VT109==2000000;
drop VT107;
rename temp VT107;


gen temp=VT116;
replace temp=. if VT116>9999000 & VT116~=.;
replace temp=32000 if VT117==15001 & VT118==49999;
replace temp=50000 if VT117==50000 & VT118==50000;
replace temp=125000 if VT117==50001 & VT118==199999;
replace temp=200000 if VT117==200000 & VT118==200000;
replace temp=1100000  if VT117==200001 & VT118==2000000;
drop VT116;
rename temp VT116;


gen house9=VT107 + VT116;
replace house9=0 if (house9==.|house9>9000000);
*/

replace VT131=. if VT131>9999000 & VT131~=.;
replace VT140=. if VT140>9999000 & VT140~=.;


gen re9=VT131 + VT140;
replace re9=0 if (re9==.|re9>9000000);


********************** impute VT173 using brackets ***********;

***post-exit***;
replace VT173=WPT173 if (VT173==. |VT173>=9999999998) & WPT173<99999998;
gen bracketflag1=1 if (VT174==. & VT175==.)|(VT174==0 & VT175==99999996);
replace VT174=WPT174 if (VT173==. |VT173>=9999999998) & WPT174~=. & bracketflag==1;
replace VT175=WPT175 if (VT173==. |VT173>=9999999998) & WPT175~=. & bracketflag==1;
replace VT173=9999999998 if VT173==. & VT174~=.;
drop bracketflag;
***************;

replace estateflag9=2 if (VT173~=. & VT173<9999990000);
replace estateflag9=3 if (VT174>0 & VT174<2000001)  & (VT175>0 & VT175<2000001);
replace estateflag9=4 if VT174==0 & VT175<2000001 & VT175~=.;
replace estateflag9=5 if VT174>0 & VT174~=. & VT175>2000000 & VT175~=.;
replace estateflag9=6 if VT174 == 0 & VT175 > 2000000;
replace estateflag9=1 if estateflag9==. & VT173>9999990000;

replace VT174=0 if VT174==. & (VT173==9999999998|VT173==9999999999);      //fix annoying quirk in data;
replace VT175=99999996 if VT175==. & (VT173==9999999998|VT173==9999999999);  // fix annoying quirk in data;

gen mmiss=.;
replace mmiss=0 if VT173>-100 & VT173<9999999990; // donor group;
replace mmiss=1 if VT173>9999999990 & VT173<19999999991; // missing variable code;

replace exactvalue=VT173;
replace lowervalue=VT174;
replace uppervalue=VT175;

imputethis;
gen estate9=exactvalue;

replace VT242=WPT242 if VT242==.|VT242==8|VT242==9;
replace estate9=estate9+house9 if VT242==5;

/*
tab VT174 VT175;
gen guess = 0;
replace guess = 1 if VT174 == 0 & VT175 > 2000000;
sum VT173 VT174 VT175;
gen impute=0;
replace impute=1 if (VT173==.|VT173>999990000);
replace VT173=0 if (VT173==.|VT173>999990000);
egen mymin = min(VT175/5) if (VT175~=0 & VT175~=.);
egen mymax = max(VT174) if VT174~=.;
replace VT174 = mymin if VT174==0;
drop mymin;
replace VT175=mymax if VT175>2000000 & VT175~=.; 
drop mymax;
replace VT173=sqrt(VT174*VT175) if (VT174~=. & VT175~=.);
replace VT173 = 433451.8  if guess == 1; 
*An: I used the mean of all the observations not of the form 10000000000.;
sort impute;
by impute: sum VT173 VT174 VT175;
sort guess;
by guess: sum VT173 VT174 VT175 if impute==1;
drop guess impute;

gen estate9=VT173;
*/


********************** impute VT186 using brackets ***********;

replace VT188=9999990 if VT188>99999990 & VT188<99999999999; // this makes missing value code bigger than max range value -- need this for imputations;

replace VT187=0 if VT187==. & (VT186==9999998|VT186==9999999);      //fix annoying quirk in data;
replace VT188=9999990 if VT188==. & (VT186==9999998|VT186==9999999);  // fix annoying quirk in data;

gen mmiss=.;
replace mmiss=0 if VT186>-100 & VT186<9999990; // donor group;
replace mmiss=1 if VT186>9999990 & VT186<19999991; // missing variable code;

replace exactvalue=VT186;
replace lowervalue=VT187;
replace uppervalue=VT188;

imputethis;
gen inspay9=exactvalue;

/*
tab VT187 VT188;
gen guess = 0;
replace guess = 1 if VT187 == 0 & VT188 > 100000;
sum VT186 VT187 VT188;
gen impute=0;
replace impute=1 if (VT186==.|VT186>9999900);
replace VT186=0 if (VT186==.|VT186>9999900);
egen mymin=min(VT188/5) if (VT188~=0 & VT188~=.);
egen mymax=max(VT187) if VT187~=.;
replace VT187=mymin if VT187==0;
drop mymin;
replace VT188=mymax if VT188>mymax & VT188~=.;
drop mymax;
replace VT186=sqrt(VT187*VT188) if (VT187~=. & VT188~=.);
replace VT186 = 37555.3  if guess == 1; 
*An: I used the mean minus any observations that were of the form 999999x;
sort impute;
by impute: sum VT186 VT187 VT188;
sort guess;
by guess: sum VT186 VT187 VT188 if impute==1;
drop guess impute;

gen inspay9=VT186;
*/

********************** impute VT148 using brackets ***********;

replace VT149=0 if VT149==. & VT148>9999999990 & VT148<99999999999;      //fix annoying quirk in data;
replace VT150=99999996 if VT150==. & VT148>9999999990 & VT148<99999999999;  // fix annoying quirk in data;

gen mmiss=.;
replace mmiss=0 if VT148>-100 & VT148<9999999990; // donor group;
replace mmiss=1 if VT148>9999999990 & VT148<19999999991; // missing variable code;

replace exactvalue=VT148;
replace lowervalue=VT149;
replace uppervalue=VT150;

imputethis;
gen deathex9=exactvalue;

/*
tab VT149 VT150;
gen guess = 0;
replace guess = 1 if VT149 == 0 & VT150 > 25000;
sum VT148 VT149 VT150;
gen impute=0;
replace impute=1 if (VT148==.|VT148>99990);
replace VT148=0 if (VT148==.|VT148>99990);
egen mymin=min(VT150/5) if (VT150~=0 & VT150~=.);
egen mymax=max(VT149) if VT149~=.;
replace VT149=mymin if VT149==0;  
drop mymin;
replace VT150=mymax if VT150>mymax & VT150~=.;
drop mymax;
replace VT148=sqrt(VT149*VT150) if (VT149~=. & VT150~=.);
replace VT148 = 7554.8 if guess == 1;
sort impute;
by impute: sum VT148 VT149 VT150;
sort guess;
by guess: sum VT148 VT149 VT150 if impute==1;
drop guess impute;

gen deathex9=VT148;
*/


********************** impute amspouse9 using brackets ***********;
gen amspouse9=VT9002 if VT9002<9999998;
replace amspouse9=estate9*VT9003/100 if amspouse9==. & VT9003<101;
replace amspouse9=WPT9002 if WPT9002<9999998 & amspouse9==.;
replace amspouse9=estate9*WPT9003/100 if amspouse9==. & WPT9003<101;
replace amspouse9=estate9 if amspouse9==100;

replace VT9004=WPT9004 if WPT9004~=. & (VT9004==.|VT9004==8|VT9004==9) & VT9005==. & VT9006==. & VT9007==. & VT9008==.;
replace VT9005=WPT9005 if WPT9005~=. & VT9004==1 & (VT9005==.|VT9005==8|VT9005==9) & VT9006==. & VT9007==. & VT9008==.; 
replace VT9006=WPT9006 if WPT9006~=. & VT9004==1 & VT9005==1 & (VT9006==.|VT9006==8|VT9007==9) & VT9007==. & VT9008==.;
replace VT9007=WPT9007 if WPT9007~=. & VT9004==5 & (VT9007==.|VT9007==8|VT9007==9) & VT9005==. & VT9006==. & VT9008==.;
replace VT9008=WPT9008 if WPT9008~=. & VT9004==5 & VT9007==5 & (VT9008==.|VT9008==8|VT9008==9) & VT9005==. & VT9006==.;


drop lowervalue uppervalue;
replace exactvalue=amspouse9/estate9*100;
replace exactvalue=100 if exactvalue>100 & exactvalue<.;

gen lowervalue=50 if VT9004==1;
gen uppervalue=50 if VT9004==5;
replace lowervalue=75 if VT9005==1;
replace uppervalue=75 if VT9005==5;
replace lowervalue=90 if VT9006==1;
replace uppervalue=90 if VT9006==5;
replace lowervalue=25 if VT9007==1;
replace uppervalue=25 if VT9007==5;
replace lowervalue=10 if VT9008==1;
replace uppervalue=10 if VT9008==5;
replace lowervalue=0 if VT9008==5;
replace uppervalue=100 if VT9006==1;

replace lowervalue=0 if (lowervalue==. & uppervalue~=.)|(VT9004==8|VT9004==9);
replace uppervalue=100 if (lowervalue~=. & uppervalue==.)|(VT9004==8|VT9004==9);

replace exactvalue=998 if exactvalue==. & lowervalue~=.;

gen mmiss=.;
replace mmiss=0 if exactvalue>-1 & exactvalue<101; // donor group;
replace mmiss=1 if exactvalue>100 & exactvalue<9999; // missing variable code;

imputethis;
replace amspouse9=estate9*exactvalue/100;



gen deathins9=VT153;
gen temp=deathins9;
replace temp=. if deathins9>9990000 & deathins9~=.;
drop deathins9;
rename temp deathins9;



gen housebequeathA9=VT102;
gen housebequeathB9=VT111;
*gen housebequeathC9=VT126;  
* PHIL: I can't find this one *JON: (Neither can I);
gen housebequeathD9=VT135;


keep death*  HHID PN house* estate* inspay* re* HHID PN housebeq* house* estate* inspay* deathex* amsp* VT107 VT116;
gen temp=real(HHID);
drop HHID;
rename temp HHID;
gen temp=real(PN);
drop PN;
rename temp PN;
sort HHID PN;

sort HHID PN;
merge HHID PN using `saved'exitassets;
drop _merge;

summ  HHID PN death* estate* inspay* re* HHID PN  house* estate* ins*;
keep   HHID PN death* estate* inspay* re* HHID PN  house* estate* ins* amsp*;  

sort HHID PN;
save `saved'exitassets, replace;

drop _all;

**********************************Wave X**********************;
clear; 

*******************read in post-exit data and update prefixes/year below when post-exit comes out for wave 10**************; 
***post-exit data***;
use `wave11d'px12T_R;
keep if XPEXITIW==2010;
sort HHID PN;
tempfile temp;
save `temp', replace;
********************; 


use `wave10d'X10T_R, clear; //data is not imputed;

****merge in post exit data below********;
merge 1:1 HHID PN using `temp'; 


gen estateflag10=.;
*gen housebequeathA1=.;
*gen housebequeathB1=.;
*gen housebequeathC1=.;
*gen housebequeathD1=.;

********************** impute WT107 and WT116 using brackets ***********;

*sum WT107 if WT107~=. & WT116~=. //check that variables are mutually exclusive (should be 0 observations)

*update with post-exit data as done above in wave 9;

replace WT107=0 if WT107==. & WT116~=.;
replace WT116=0 if WT116==. & WT107~=.;
replace WT108=0 if WT108==. & WT117~=.;
replace WT117=0 if WT117==. & WT108~=.;
replace WT109=0 if WT109==. & WT118~=.;
replace WT118=0 if WT118==. & WT109~=.;

gen house10 = WT107 + WT116;

replace WT109= 9999990 if WT109>99999000 & WT109<99999999999; // this makes missing value code bigger than max range value -- need this for imputations;
replace WT118= 9999990 if WT118>99999000 & WT118<99999999999; //make sure that DK/NA/Refused and above-breakpoint codes haven't changed since previous round


gen mmiss=.;
replace mmiss=0 if house10>-100 & house10<9999991; // donor group;
replace mmiss=1 if house10>9999990 & house10<19999001; // missing variable code;


gen lowervalue= WT108 + WT117;
gen uppervalue= WT109 + WT118;

replace lowervalue=0 if lowervalue==. & (house10==9999998|house10==9999999);      //fix annoying quirk in data;
replace uppervalue=99999996 if uppervalue==. & (house10==9999998|house10==9999999);  // fix annoying quirk in data;

gen exactvalue=house10;

imputethis;
replace house10=exactvalue;


/* OLD IMPUTATION CODE
replace WT107=0 if WT107==. & WT116~=.;
replace WT116=0 if WT116==. & WT107~=.;

gen temp=WT107;
replace temp=. if WT107>9999000 & WT107~=.;
replace temp=32000 if WT108==15001 & WT109==49999;
replace temp=50000 if WT108==50000 & WT109==50000;
replace temp=125000 if WT108==50001 & WT109==199999;
replace temp=200000 if WT108==200000 & WT109==200000;
replace temp=1100000 if WT108==200001 & WT109==2000000;
drop WT107;
rename temp WT107;


gen temp=WT116;
replace temp=. if WT116>9999000 & WT116~=.;
replace temp=32000 if WT117==15001 & WT118==49999;
replace temp=50000 if WT117==50000 & WT118==50000;
replace temp=125000 if WT117==50001 & WT118==199999;
replace temp=200000 if WT117==200000 & WT118==200000;
replace temp=1100000  if WT117==200001 & WT118==2000000;
drop WT116;
rename temp WT116;


gen house10=WT107 + WT116;
replace house10=0 if (house10==.|house10>9000000);
*/

replace WT131=. if WT131>9999000 & WT131~=.;
replace WT140=. if WT140>9999000 & WT140~=.;


gen re10=WT131 + WT140;
replace re10=0 if (re10==.|re10>9000000);

replace estateflag10=2 if (WT173~=. & WT173<999990000);
replace estateflag10=3 if (WT174>0 & WT174<2000001)  & (WT175>0 & WT175<2000001);
replace estateflag10=4 if WT174==0 & WT175<2000001 & WT175~=.;
replace estateflag10=5 if WT174>0 & WT174~=. & WT175>2000000 & WT175~=.;
replace estateflag10=6 if WT174 == 0 & WT175 > 2000000;
replace estateflag10=1 if estateflag10==. & WT173>999990000;

********************** impute WT173 using brackets ***********;

*update with post-exit data as done above in wave 9;

replace WT175= 99999990 if WT175>99999990 & WT175<99999999999; // this makes missing value code bigger than max range value -- need this for imputations;

replace WT174=0 if WT174==. & (WT173==99999998|WT173==99999999);      //fix annoying quirk in data;
replace WT175=99999990 if WT175==. & (WT173==99999998|WT173==99999999);  // fix annoying quirk in data;

gen mmiss=.;
replace mmiss=0 if WT173>-100 & WT173<99999990; // donor group;
replace mmiss=1 if WT173>99999990 & WT173<19999999991; // missing variable code;

replace exactvalue=WT173;
replace lowervalue=WT174;
replace uppervalue=WT175;

imputethis;
gen estate10=exactvalue;

replace WT242=XPT242 if WT242==.|WT242==8|WT242==9; 
replace estate10=estate10+house10 if WT242==5;



/*
gen temp=.;
replace temp=1 if WT173~=. & WT173<99999998;
*used to set observations with guess==1 to the mean below, might need to adjust upper bound in future waves
tab WT174 WT175;
gen guess = 0;
replace guess = 1 if WT174 == 0 & WT175 > 2000000;
sum WT173 WT174 WT175;
gen impute=0;
replace impute=1 if (WT173==.|WT173>99999000);
replace WT173=0 if (WT173==.|WT173>99999000);
egen mymin = min(WT175/5) if (WT175~=0 & WT175~=.);
egen mymax = max(WT174) if WT174~=.;
replace WT174 = mymin if WT174==0;
drop mymin;
replace WT175=mymax if WT175>2000000 & WT175~=.; 
drop mymax;
replace WT173=sqrt(WT174*WT175) if (WT174~=. & WT175~=.);
sum WT173 if temp==1;
replace WT173 = r(mean) if guess == 1; 
sort impute;
by impute: sum WT173 WT174 WT175;
sort guess;
by guess: sum WT173 WT174 WT175 if impute==1;
drop guess impute temp;
gen estate10=WT173;
*/


********************** impute WT186 using brackets ***********;

replace WT188=9999990 if WT188>99999990 & WT188<99999999999; // this makes missing value code bigger than max range value -- need this for imputations;

replace WT187=0 if WT187==. & (WT186==9999998|WT186==9999999);      //fix annoying quirk in data;
replace WT188=9999990 if WT188==. & (WT186==9999998|WT186==9999999);  // fix annoying quirk in data;

gen mmiss=.;
replace mmiss=0 if WT186>-100 & WT186<9999990; // donor group;
replace mmiss=1 if WT186>9999990 & WT186<19999991; // missing variable code;

replace exactvalue=WT186;
replace lowervalue=WT187;
replace uppervalue=WT188;

imputethis;
gen inspay10=exactvalue;

/*
gen temp=.;
replace temp=1 if WT186~=. & WT186<9999998; 
*used to set observations with guess==1 to the mean below, might need to adjust upper bound in future waves
tab WT187 WT188;
gen guess = 0;
replace guess = 1 if WT187 == 0 & WT188 > 100000;
sum WT186 WT187 WT188;
gen impute=0;
replace impute=1 if (WT186==.|WT186>9999900);
replace WT186=0 if (WT186==.|WT186>9999900);
egen mymin=min(WT188/5) if (WT188~=0 & WT188~=.);
egen mymax=max(WT187) if WT187~=.;
replace WT187=mymin if WT187==0;
drop mymin;
replace WT188=mymax if WT188>mymax & WT188~=.;
drop mymax;
replace WT186=sqrt(WT187*WT188) if (WT187~=. & WT188~=.);
sum WT186 if temp==1;
replace WT186 = r(mean) if guess == 1; 
sort impute;
by impute: sum WT186 WT187 WT188;
sort guess;
by guess: sum WT186 WT187 WT188 if impute==1;
drop guess impute temp;

gen inspay10=WT186;
*/

********************** impute WT148 using brackets ***********;

replace WT150=9999990 if WT150>99999990 & WT150<99999999999; // this makes missing value code bigger than max range value -- need this for imputations;


replace WT149=0 if WT149==. & WT148>9999990 & WT148<99999999999;      //fix annoying quirk in data;
replace WT150=9999990 if WT150==. & WT148>9999990 & WT148<99999999999;  // fix annoying quirk in data;

gen mmiss=.;
replace mmiss=0 if WT148>-100 & WT148<9999990; // donor group;
replace mmiss=1 if WT148>9999990 & WT148<19999999991; // missing variable code;

replace exactvalue=WT148;
replace lowervalue=WT149;
replace uppervalue=WT150;

imputethis;
gen deathex10=exactvalue;

/*
gen temp=.;
replace temp=1 if WT148~=. & WT148<9999996;
*used to set observations with guess==1 to the mean below, might need to adjust upper bound in future waves
tab WT149 WT150;
gen guess = 0;
replace guess = 1 if WT149 == 0 & WT150 > 25000;
sum WT148 WT149 WT150;
gen impute=0;
replace impute=1 if (WT148==.|WT148>99990);
replace WT148=0 if (WT148==.|WT148>99990);
egen mymin=min(WT150/5) if (WT150~=0 & WT150~=.);
egen mymax=max(WT149) if WT149~=.;
replace WT149=mymin if WT149==0;  
drop mymin;
replace WT150=mymax if WT150>mymax & WT150~=.;
drop mymax;
replace WT148=sqrt(WT149*WT150) if (WT149~=. & WT150~=.);
sum WT148 if temp==1;
replace WT148 = r(mean) if guess == 1;
sort impute;
by impute: sum WT148 WT149 WT150;
sort guess;
by guess: sum WT148 WT149 WT150 if impute==1;
drop guess impute temp;

gen deathex10=WT148;
*/


********************** impute amspouse10 using brackets ***********;

**********************Uncomment below and update prefixes when post-exit data is available**************************;

gen amspouse10=WT9002 if WT9002<9999998;
replace amspouse10=estate10*WT9003/100 if amspouse10==. & WT9003<101;
replace amspouse10=XPT9002 if XPT9002<9999998 & amspouse10==.;
replace amspouse10=estate10*XPT9003/100 if amspouse10==. & XPT9003<101;
replace amspouse10=estate10 if amspouse10==100;

replace WT9004=XPT9004 if XPT9004~=. & (WT9004==.|WT9004==8|WT9004==9) & WT9005==. & WT9006==. & WT9007==. & WT9008==.;
replace WT9005=XPT9005 if XPT9005~=. & WT9004==1 & (WT9005==.|WT9005==8|WT9005==9) & WT9006==. & WT9007==. & WT9008==.; 
replace WT9006=XPT9006 if XPT9006~=. & WT9004==1 & WT9005==1 & (WT9006==.|WT9006==8|WT9007==9) & WT9007==. & WT9008==.;
replace WT9007=XPT9007 if XPT9007~=. & WT9004==5 & (WT9007==.|WT9007==8|WT9007==9) & WT9005==. & WT9006==. & WT9008==.;
replace WT9008=XPT9008 if XPT9008~=. & WT9004==5 & WT9007==5 & (WT9008==.|WT9008==8|WT9008==9) & WT9005==. & WT9006==.;


drop lowervalue uppervalue;
replace exactvalue=amspouse10/estate10*100;
replace exactvalue=100 if exactvalue>100 & exactvalue<.;

gen lowervalue=50 if WT9004==1;
gen uppervalue=50 if WT9004==5;
replace lowervalue=75 if WT9005==1;
replace uppervalue=75 if WT9005==5;
replace lowervalue=90 if WT9006==1;
replace uppervalue=90 if WT9006==5;
replace lowervalue=25 if WT9007==1;
replace uppervalue=25 if WT9007==5;
replace lowervalue=10 if WT9008==1;
replace uppervalue=10 if WT9008==5;
replace lowervalue=0 if WT9008==5;
replace uppervalue=100 if WT9006==1;

replace lowervalue=0 if (lowervalue==. & uppervalue~=.)|(WT9004==8|WT9004==9);
replace uppervalue=100 if (lowervalue~=. & uppervalue==.)|(WT9004==8|WT9004==9);

replace exactvalue=998 if exactvalue==. & lowervalue~=.;

gen mmiss=.;
replace mmiss=0 if exactvalue>-1 & exactvalue<101; // donor group;
replace mmiss=1 if exactvalue>100 & exactvalue<9999; // missing variable code;

imputethis;
replace amspouse10=estate10*exactvalue/100;


gen deathins10=WT153;
gen temp=deathins10;
replace temp=. if deathins10>9990000 & deathins10~=.;
drop deathins10;
rename temp deathins10;



gen housebequeathA10=WT102;
gen housebequeathB10=WT111;
*gen housebequeathC10=WT126;  
* PHIL: I can't find this one *JON: (Neither can I);
gen housebequeathD10=WT135;


keep death*  HHID PN house* estate* inspay* re* HHID PN housebeq* house* estate* inspay* deathex* amsp* WT107 WT116;
gen temp=real(HHID);
drop HHID;
rename temp HHID;
gen temp=real(PN);
drop PN;
rename temp PN;
sort HHID PN;

sort HHID PN;
merge HHID PN using `saved'exitassets;
drop _merge;


summ  HHID PN death* estate* inspay* re* HHID PN  house* estate* ins*;
keep   HHID PN death* estate* inspay* re* HHID PN  house* estate* ins* amsp*;  

sort HHID PN;
save `saved'exitassets, replace;

drop _all;


**********************************Wave XI  **********************;
clear; 

*******************read in post-exit data and update prefixes/year below when post-exit comes out for wave 11**************; 
***post-exit data***;
use `wave12d'px14T_R;
keep if YPEXITIW==2012;
sort HHID PN;
tempfile temp;
save `temp', replace;
********************; 


use `wave11d'X12T_R, clear; //data is not imputed;

****merge in post exit data below********;
merge 1:1 HHID PN using `temp'; 


gen estateflag11=.;
*gen housebequeathA1=.;
*gen housebequeathB1=.;
*gen housebequeathC1=.;
*gen housebequeathD1=.;

********************** impute XT107 and XT116 using brackets ***********;

*sum XT107 if XT107~=. & XT116~=. //check that variables are mutually exclusive (should be 0 observations)

*update with post-exit data as done above in wave 9;

*check this as it is not in earlier waves;


replace XT107=0 if XT107==. & XT116~=.;
replace XT116=0 if XT116==. & XT107~=.;
replace XT108=0 if XT108==. & XT117~=.;
replace XT117=0 if XT117==. & XT108~=.;
replace XT109=0 if XT109==. & XT118~=.;
replace XT118=0 if XT118==. & XT109~=.;

gen house11 = XT107 + XT116;

replace XT109= 9999990 if XT109>99999000 & XT109<99999999999; // this makes missing value code bigger than max range value -- need this for imputations;
replace XT118= 9999990 if XT118>99999000 & XT118<99999999999; //make sure that DK/NA/Refused and above-breakpoint codes haven't changed since previous round


gen mmiss=.;
replace mmiss=0 if house11>-100 & house11<9999991; // donor group;
replace mmiss=1 if house11>9999990 & house11<19999001; // missing variable code;


gen lowervalue= XT108 + XT117;
gen uppervalue= XT109 + XT118;

replace lowervalue=0 if lowervalue==. & (house11==9999998|house11==9999999);      //fix annoying quirk in data;
replace uppervalue=99999996 if uppervalue==. & (house11==9999998|house11==9999999);  // fix annoying quirk in data;

gen exactvalue=house11;

imputethis;
replace house11=exactvalue;


replace XT131=. if XT131>9999000 & XT131~=.;
replace XT140=. if XT140>9999000 & XT140~=.;


gen re11=XT131 + XT140;
replace re11=0 if (re11==.|re11>9000000);

replace estateflag11=2 if (XT173~=. & XT173<9999998);
replace estateflag11=3 if (XT174>0 & XT174<2000001)  & (XT175>0 & XT175<2000001);
replace estateflag11=4 if XT174==0 & XT175<2000001 & XT175~=.;
replace estateflag11=5 if XT174>0 & XT174~=. & XT175>2000000 & XT175~=.;
replace estateflag11=6 if XT174 == 0 & XT175 > 2000000;
replace estateflag11=1 if estateflag11==. & XT173>999990000;

********************** impute XT173 using brackets ***********;

*update with post-exit data as done above;

replace XT175= 99999990 if XT175>99999990 & XT175<99999999999; // this makes missing value code bigger than max range value -- need this for imputations;

replace XT174=0 if XT174==. & (XT173==99999998|XT173==99999999);      //fix annoying quirk in data;
replace XT175=99999990 if XT175==. & (XT173==9999998|XT173==9999999);  // fix annoying quirk in data;

gen mmiss=.;
replace mmiss=0 if XT173>-100 & XT173<9999990; // donor group;
replace mmiss=1 if XT173>9999990 & XT173<19999999991; // missing variable code;

replace exactvalue=XT173;
replace lowervalue=XT174;
replace uppervalue=XT175;

imputethis;
gen estate11=exactvalue;

replace XT242=YPT242 if XT242==.|XT242==8|XT242==9; 
replace estate11=estate11+house11 if XT242==5;





********************** impute XT186 using brackets ***********;

replace XT188=9999990 if XT188>99999990 & XT188<99999999999; // this makes missing value code bigger than max range value -- need this for imputations;

replace XT187=0 if XT187==. & (XT186==9999998|XT186==9999999);      //fix annoying quirk in data;
replace XT188=9999990 if XT188==. & (XT186==9999998|XT186==9999999);  // fix annoying quirk in data;

gen mmiss=.;
replace mmiss=0 if XT186>-100 & XT186<9999990; // donor group;
replace mmiss=1 if XT186>9999990 & XT186<19999991; // missing variable code;

replace exactvalue=XT186;
replace lowervalue=XT187;
replace uppervalue=XT188;

imputethis;
gen inspay11=exactvalue;

********************** impute XT148 using brackets ***********;

replace XT150=9999990 if XT150>99999990 & XT150<99999999999; // this makes missing value code bigger than max range value -- need this for imputations;


replace XT149=0 if XT149==. & XT148>99990 & XT148<99999999999;      //fix annoying quirk in data;
replace XT150=9999990 if XT150==. & XT148>99990 & XT148<99999999999;  // fix annoying quirk in data;

gen mmiss=.;
replace mmiss=0 if XT148>-100 & XT148<100000;// donor group;
replace mmiss=1 if XT148>100000 & XT148<19999999991; // missing variable code;

replace exactvalue=XT148;
replace lowervalue=XT149;
replace uppervalue=XT150;

imputethis;
gen deathex11=exactvalue;
replace deathex11 =. if deathex11 ==99998 | deathex11 ==99997 | deathex11 ==99996 | deathex11 ==99999;

********************** impute amspouse11 using brackets ***********;

**********************Uncomment below and update prefixes when post-exit data is available**************************;

gen amspouse11=XT9002 if XT9002<9999998;
replace amspouse11=estate11*XT9003/100 if amspouse11==. & XT9003<101;
replace amspouse11=YPT9002 if YPT9002<9999998 & amspouse11==.;
replace amspouse11=estate11*YPT9003/100 if amspouse11==. & YPT9003<101;
replace amspouse11=estate11 if amspouse11==100;

replace XT9004=YPT9004 if YPT9004~=. & (XT9004==.|XT9004==8|XT9004==9) & XT9005==. & XT9006==. & XT9007==. & XT9008==.;
replace XT9005=YPT9005 if YPT9005~=. & XT9004==1 & (XT9005==.|XT9005==8|XT9005==9) & XT9006==. & XT9007==. & XT9008==.; 
replace XT9006=YPT9006 if YPT9006~=. & XT9004==1 & XT9005==1 & (XT9006==.|XT9006==8|XT9007==9) & XT9007==. & XT9008==.;
replace XT9007=YPT9007 if YPT9007~=. & XT9004==5 & (XT9007==.|XT9007==8|XT9007==9) & XT9005==. & XT9006==. & XT9008==.;
replace XT9008=YPT9008 if YPT9008~=. & XT9004==5 & XT9007==5 & (XT9008==.|XT9008==8|XT9008==9) & XT9005==. & XT9006==.;


drop lowervalue uppervalue;
replace exactvalue=amspouse11/estate11*100;
replace exactvalue=100 if exactvalue>100 & exactvalue<.;

gen lowervalue=50 if XT9004==1;
gen uppervalue=50 if XT9004==5;
replace lowervalue=75 if XT9005==1;
replace uppervalue=75 if XT9005==5;
replace lowervalue=90 if XT9006==1;
replace uppervalue=90 if XT9006==5;
replace lowervalue=25 if XT9007==1;
replace uppervalue=25 if XT9007==5;
replace lowervalue=10 if XT9008==1;
replace uppervalue=10 if XT9008==5;
replace lowervalue=0 if XT9008==5;
replace uppervalue=100 if XT9006==1;

replace lowervalue=0 if (lowervalue==. & uppervalue~=.)|(XT9004==8|XT9004==9);
replace uppervalue=100 if (lowervalue~=. & uppervalue==.)|(XT9004==8|XT9004==9);

replace exactvalue=998 if exactvalue==. & lowervalue~=.;

gen mmiss=.;
replace mmiss=0 if exactvalue>-1 & exactvalue<101; // donor group;
replace mmiss=1 if exactvalue>100 & exactvalue<9999; // missing variable code;

imputethis;
replace amspouse11=estate11*exactvalue/100;


gen deathins11=XT153;
gen temp=deathins11;
replace temp=. if deathins11>9990000 & deathins11~=.;
drop deathins11;
rename temp deathins11;



gen housebequeathA11=XT102;
gen housebequeathB11=XT111;
*gen housebequeathC10=XT126;  
* PHIL: I can't find this one *JON: (Neither can I);
gen housebequeathD11=XT135;


keep death*  HHID PN house* estate* inspay* re* HHID PN housebeq* house* estate* inspay* deathex* amsp* XT117 XT116;
gen temp=real(HHID);
drop HHID;
rename temp HHID;
gen temp=real(PN);
drop PN;
rename temp PN;
sort HHID PN;

sort HHID PN;
merge HHID PN using `saved'exitassets;
drop _merge;

summ  HHID PN death* estate* inspay* re* HHID PN  house* estate* ins*;
keep   HHID PN death* estate* inspay* re* HHID PN  house* estate* ins* amsp*; 
sort HHID PN;
save `saved'exitassets, replace;
**********************************Wave XII**********************;
clear; 

*******************read in post-exit data and update prefixes/year below when post-exit comes out for wave 12**************; 
***post-exit data***;
use `wave13d'px16T_R;
keep if ZPEXITIW==2014;
sort HHID PN;
tempfile temp;
save `temp', replace;
********************; 


use `wave12d'X14T_R, clear; //data is not imputed;

****merge in post exit data below********;
merge 1:1 HHID PN using `temp'; 


gen estateflag12=.;
*gen housebequeathA1=.;
*gen housebequeathB1=.;
*gen housebequeathC1=.;
*gen housebequeathD1=.;

********************** impute YT107 and YT116 using brackets ***********;

*sum YT107 if YT107~=. & YT116~=. //check that variables are mutually exclusive (should be 0 observations);
*    Variable |        Obs        Mean    Std. Dev.       Min        Max;
*-------------+---------------------------------------------------------;
*       YT107 |          0;

*update with post-exit data as done above in wave 9;

replace YT107=0 if YT107==. & YT116~=.;
replace YT116=0 if YT116==. & YT107~=.;
replace YT108=0 if YT108==. & YT117~=.;
replace YT117=0 if YT117==. & YT108~=.;
replace YT109=0 if YT109==. & YT118~=.;
replace YT118=0 if YT118==. & YT109~=.;

gen house12 = YT107 + YT116;
*Have a look at this = it is similar to previous waves;
replace YT109= 9999990 if YT109>99999000 & YT109<99999999999; // this makes missing value code bigger than max range value -- need this for imputations;
replace YT118= 9999990 if YT118>99999000 & YT118<99999999999; //make sure that DK/NA/Refused and above-breakpoint codes haven't changed since previous round;


gen mmiss=.;
replace mmiss=0 if house12>-100 & house12<9999991; // donor group;
replace mmiss=1 if house12>9999990 & house12<19999001; // missing variable code;


gen lowervalue= YT108 + YT117;
gen uppervalue= YT109 + YT118;

replace lowervalue=0 if lowervalue==. & (house12==9999998|house12==9999999);      //fix annoying quirk in data;
replace uppervalue=99999996 if uppervalue==. & (house12==9999998|house12==9999999);  // fix annoying quirk in data;

gen exactvalue=house12;

imputethis;
replace house12=exactvalue;

********************************************************************************;
/* OLD IMPUTATION CODE
replace YT107=0 if YT107==. & YT116~=.;
replace YT116=0 if YT116==. & YT107~=.;

gen temp=YT107;
replace temp=. if YT107>9999000 & YT107~=.;
replace temp=32000 if YT108==15001 & YT109==49999;
replace temp=50000 if YT108==50000 & YT109==50000;
replace temp=125000 if YT108==50001 & YT109==199999;
replace temp=200000 if YT108==200000 & YT109==200000;
replace temp=1100000 if YT108==200001 & YT109==2000000;
drop YT107;
rename temp YT107;


gen temp=YT116;
replace temp=. if YT116>9999000 & YT116~=.;
replace temp=32000 if YT117==15001 & YT118==49999;
replace temp=50000 if YT117==50000 & YT118==50000;
replace temp=125000 if YT117==50001 & YT118==199999;
replace temp=200000 if YT117==200000 & YT118==200000;
replace temp=1100000  if YT117==200001 & YT118==2000000;
drop YT116;
rename temp YT116;


gen house12=YT107 + YT116;
replace house12=0 if (house12==.|house12>9000000);
*/
********************************************************************************;


*replace YT131=. if YT131>9999000 & YT131~=.;
*replace YT140=. if YT140>9999000 & YT140~=.;

*gen re12=YT131 + YT140;
gen re12=.;
*replace re12=0 if (re12==.|re12>9000000);

replace estateflag12=2 if (YT173~=. & YT173<90000000);
replace estateflag12=3 if (YT174>0 & YT174<2000002)  & (YT175>0 & YT175<2000001); //**check with eric;
replace estateflag12=4 if YT174==0 & YT175<2000001 & YT175~=.;
replace estateflag12=5 if YT174>0 & YT174~=. & YT175>2000000 & YT175~=.;
replace estateflag12=6 if YT174 == 0 & YT175 > 2000000;
replace estateflag12=1 if estateflag12==. & YT173>999990000;                    //*check with eric;

********************** impute YT173 using brackets ***********;

*update with post-exit data as done above in wave 9;

replace YT175= 99999990 if YT175>99999990 & YT175<99999999999; // this makes missing value code bigger than max range value -- need this for imputations;

replace YT174=0 if YT174==. & (YT173==99999998|YT173==99999999);      //fix annoying quirk in data;
replace YT175=99999990 if YT175==. & (YT173==99999998|YT173==99999999);  // fix annoying quirk in data; //check this with Eric - previous waves might need work;

gen mmiss=.;
replace mmiss=0 if YT173>-100 & YT173<99999990; // donor group;
replace mmiss=1 if YT173>99999990 & YT173<19999999991; // missing variable code;

replace exactvalue=YT173;
replace lowervalue=YT174;
replace uppervalue=YT175;

imputethis;
gen estate12=exactvalue;

replace YT242=ZPT242 if YT242==.|YT242==8|YT242==9; //uncomment this line and update prefixes when we get post exit info for wave 12;
replace estate12=estate12+house12 if YT242==5;



/*
gen temp=.;
replace temp=1 if YT173~=. & YT173<99999998;
*used to set observations with guess==1 to the mean below, might need to adjust upper bound in future waves
tab YT174 YT175;
gen guess = 0;
replace guess = 1 if YT174 == 0 & YT175 > 2000000;
sum YT173 YT174 YT175;
gen impute=0;
replace impute=1 if (YT173==.|YT173>99999000);
replace YT173=0 if (YT173==.|YT173>99999000);
egen mymin = min(YT175/5) if (YT175~=0 & YT175~=.);
egen mymax = max(YT174) if YT174~=.;
replace YT174 = mymin if YT174==0;
drop mymin;
replace YT175=mymax if YT175>2000000 & YT175~=.; 
drop mymax;
replace YT173=sqrt(YT174*YT175) if (YT174~=. & YT175~=.);
sum YT173 if temp==1;
replace YT173 = r(mean) if guess == 1; 
sort impute;
by impute: sum YT173 YT174 YT175;
sort guess;
by guess: sum YT173 YT174 YT175 if impute==1;
drop guess impute temp;
gen estate12=YT173;
*/


********************** impute YT186 using brackets ***********;

replace YT188=9999990 if YT188>99999990 & YT188<99999999999; // this makes missing value code bigger than max range value -- need this for imputations;

replace YT187=0 if YT187==. & (YT186==9999998|YT186==9999999);      //fix annoying quirk in data;
replace YT188=9999990 if YT188==. & (YT186==9999998|YT186==9999999);  // fix annoying quirk in data;
*check this with eric;
gen mmiss=.;
replace mmiss=0 if YT186>-100 & YT186<9999990; // donor group;
replace mmiss=1 if YT186>9999990 & YT186<19999991; // missing variable code;

replace exactvalue=YT186;
replace lowervalue=YT187;
replace uppervalue=YT188;

imputethis;
gen inspay12=exactvalue;

/*
gen temp=.;
replace temp=1 if YT186~=. & YT186<9999998; 
*used to set observations with guess==1 to the mean below, might need to adjust upper bound in future waves
tab YT187 YT188;
gen guess = 0;
replace guess = 1 if YT187 == 0 & YT188 > 100000;
sum YT186 YT187 YT188;
gen impute=0;
replace impute=1 if (YT186==.|YT186>9999900);
replace YT186=0 if (YT186==.|YT186>9999900);
egen mymin=min(YT188/5) if (YT188~=0 & YT188~=.);
egen mymax=max(YT187) if YT187~=.;
replace YT187=mymin if YT187==0;
drop mymin;
replace YT188=mymax if YT188>mymax & YT188~=.;
drop mymax;
replace YT186=sqrt(YT187*YT188) if (YT187~=. & YT188~=.);
sum YT186 if temp==1;
replace YT186 = r(mean) if guess == 1; 
sort impute;
by impute: sum YT186 YT187 YT188;
sort guess;
by guess: sum YT186 YT187 YT188 if impute==1;
drop guess impute temp;

gen inspay12=YT186;
*/

********************** impute YT148 using brackets ***********;

replace YT150=9999990 if YT150>99999990 & YT150<99999999999; // this makes missing value code bigger than max range value -- need this for imputations;

replace YT149=0 if YT149==. & YT148>99990 & YT148<99999999999;      //fix annoying quirk in data;
replace YT150=9999990 if YT150==. & YT148>99990 & YT148<99999999999;  // fix annoying quirk in data;

gen mmiss=.;
replace mmiss=0 if YT148>-100 & YT148<100000; // donor group;
replace mmiss=1 if YT148>100000 & YT148<19999999991; // missing variable code;

replace exactvalue=YT148;
replace lowervalue=YT149;
replace uppervalue=YT150;

imputethis;
gen deathex12=exactvalue;
replace deathex12 =. if deathex12 ==99998 | deathex12 ==99997 | deathex12 ==99996 | deathex12 ==99999;
/*
gen temp=.;
replace temp=1 if YT148~=. & YT148<99996;
*used to set observations with guess==1 to the mean below, might need to adjust upper bound in future waves
tab YT149 YT150;
gen guess = 0;
replace guess = 1 if YT149 == 0 & YT150 > 25000;
sum YT148 YT149 YT150;
gen impute=0;
replace impute=1 if (YT148==.|YT148>99990);
replace YT148=0 if (YT148==.|YT148>99990);
egen mymin=min(YT150/5) if (YT150~=0 & YT150~=.);
egen mymax=max(YT149) if YT149~=.;
replace YT149=mymin if YT149==0;  
drop mymin;
replace YT150=mymax if YT150>mymax & YT150~=.;
drop mymax;
replace YT148=sqrt(YT149*YT150) if (YT149~=. & YT150~=.);
sum YT148 if temp==1;
replace YT148 = r(mean) if guess == 1;
sort impute;
by impute: sum YT148 YT149 YT150;
sort guess;
by guess: sum YT148 YT149 YT150 if impute==1;
drop guess impute temp;

gen deathex12=YT148;
*/


********************** impute amspouse12 using brackets ***********;

**********************Uncomment below and update prefixes when post-exit data is available**************************;

gen amspouse12=YT9002 if YT9002<9999998;
replace amspouse12=estate12*YT9003/100 if amspouse12==. & YT9003<101;
replace amspouse12=ZPT9002 if ZPT9002<9999998 & amspouse12==.;
replace amspouse12=estate12*ZPT9003/100 if amspouse12==. & ZPT9003<101;
replace amspouse12=estate12 if amspouse12==100;

replace YT9004=ZPT9004 if ZPT9004~=. & (YT9004==.|YT9004==8|YT9004==9) & YT9005==. & YT9006==. & YT9007==. & YT9008==.;
replace YT9005=ZPT9005 if ZPT9005~=. & YT9004==1 & (YT9005==.|YT9005==8|YT9005==9) & YT9006==. & YT9007==. & YT9008==.; 
replace YT9006=ZPT9006 if ZPT9006~=. & YT9004==1 & YT9005==1 & (YT9006==.|YT9006==8|YT9007==9) & YT9007==. & YT9008==.;
replace YT9007=ZPT9007 if ZPT9007~=. & YT9004==5 & (YT9007==.|YT9007==8|YT9007==9) & YT9005==. & YT9006==. & YT9008==.;
replace YT9008=ZPT9008 if ZPT9008~=. & YT9004==5 & YT9007==5 & (YT9008==.|YT9008==8|YT9008==9) & YT9005==. & YT9006==.;


drop lowervalue uppervalue;
replace exactvalue=amspouse12/estate12*100;
replace exactvalue=100 if exactvalue>100 & exactvalue<.;

gen lowervalue=50 if YT9004==1;
gen uppervalue=50 if YT9004==5;
replace lowervalue=75 if YT9005==1;
replace uppervalue=75 if YT9005==5;
replace lowervalue=90 if YT9006==1;
replace uppervalue=90 if YT9006==5;
replace lowervalue=25 if YT9007==1;
replace uppervalue=25 if YT9007==5;
replace lowervalue=10 if YT9008==1;
replace uppervalue=10 if YT9008==5;
replace lowervalue=0 if YT9008==5;
replace uppervalue=100 if YT9006==1;

replace lowervalue=0 if (lowervalue==. & uppervalue~=.)|(YT9004==8|YT9004==9);
replace uppervalue=100 if (lowervalue~=. & uppervalue==.)|(YT9004==8|YT9004==9);

replace exactvalue=998 if exactvalue==. & lowervalue~=.;

gen mmiss=.;
replace mmiss=0 if exactvalue>-1 & exactvalue<101; // donor group;
replace mmiss=1 if exactvalue>100 & exactvalue<9999; // missing variable code;

imputethis;
replace amspouse12=estate12*exactvalue/100;


gen deathins12=YT153;
gen temp=deathins12;
replace temp=. if deathins12>9990000 & deathins12~=.;
drop deathins12;
rename temp deathins12;



gen housebequeathA12=YT102;
gen housebequeathB12=YT111;
*gen housebequeathC12=YT126;  
* PHIL: I can't find this one *JON: (Neither can I);
*gen housebequeathD12=YT135; *Ali: Question taken out of wave 12;


keep death*  HHID PN house* estate* inspay*  HHID PN housebeq* house* estate* inspay* deathex* amsp*  YT116;
gen temp=real(HHID);
drop HHID;
rename temp HHID;
gen temp=real(PN);
drop PN;
rename temp PN;
sort HHID PN;

sort HHID PN;
merge HHID PN using `saved'exitassets;
drop _merge;


summ  HHID PN death* estate* inspay* re* HHID PN  house* estate* ins*;
keep   HHID PN death* estate* inspay* re* HHID PN  house* estate* ins* amsp*;  

sort HHID PN;
save `saved'exitassets, replace;


**********************************Start Wave 13**********************;
clear; 

*******************read in post-exit data and update prefixes/year below when post-exit comes out for wave 13**************; 

***post-exit data***;*************;
*use `wave14d'px18T_R;           *;
*keep if ZPEXITIW==2016;         *;
*sort HHID PN;                   *Uncomment this when wave 14 final post-exit data are out and added to the dropbox;
*tempfile temp;                  *Chris: It's still not there as of Sep 2022;
*save `temp', replace;           *;
********************;*************;

use `wave13d'X16T_R, clear; //data is not imputed;



****merge in post exit data below********;
*merge 1:1 HHID PN using `temp'; 


gen estateflag13=.;
*gen housebequeathA1=.;
*gen housebequeathB1=.;
*gen housebequeathC1=.;
*gen housebequeathD1=.;

********************** impute ZT107 and ZT116 using brackets ***********;

*sum ZT107 if ZT107~=. & ZT116~=. //check that variables are mutually exclusive (should be 0 observations);
*    Variable |        Obs        Mean    Std. Dev.       Min        Max;
*-------------+---------------------------------------------------------;
*       ZT107 |          0;

*update with post-exit data as done above in wave 9;

replace ZT107=0 if ZT107==. & ZT116~=.;
replace ZT116=0 if ZT116==. & ZT107~=.;
replace ZT108=0 if ZT108==. & ZT117~=.;
replace ZT117=0 if ZT117==. & ZT108~=.;
replace ZT109=0 if ZT109==. & ZT118~=.;
replace ZT118=0 if ZT118==. & ZT109~=.;

gen house13 = ZT107 + ZT116;
*Have a look at this = it is similar to previous waves;
replace ZT109= 9999990 if ZT109>99999000 & ZT109<99999999999; // this makes missing value code bigger than max range value -- need this for imputations;
replace ZT118= 9999990 if ZT118>99999000 & ZT118<99999999999; //make sure that DK/NA/Refused and above-breakpoint codes haven't changed since previous round


gen mmiss=.;
replace mmiss=0 if house13>-100 & house13<9999991; // donor group;
replace mmiss=1 if house13>9999990 & house13<19999001; // missing variable code;


gen lowervalue= ZT108 + ZT117;
gen uppervalue= ZT109 + ZT118;

replace lowervalue=0 if lowervalue==. & (house13==9999998|house13==9999999);      //fix annoying quirk in data;
replace uppervalue=99999996 if uppervalue==. & (house13==9999998|house13==9999999);  // fix annoying quirk in data;

gen exactvalue=house13;

imputethis;
replace house13=exactvalue;

********************************************************************************
/* OLD IMPUTATION CODE
replace ZT107=0 if ZT107==. & ZT116~=.;
replace ZT116=0 if ZT116==. & ZT107~=.;

gen temp=ZT107;
replace temp=. if ZT107>9999000 & ZT107~=.;
replace temp=32000 if ZT108==15001 & ZT109==49999;
replace temp=50000 if ZT108==50000 & ZT109==50000;
replace temp=125000 if ZT108==50001 & ZT109==199999;
replace temp=200000 if ZT108==200000 & ZT109==200000;
replace temp=1100000 if ZT108==200001 & ZT109==2000000;
drop ZT107;
rename temp ZT107;


gen temp=ZT116;
replace temp=. if ZT116>9999000 & ZT116~=.;
replace temp=32000 if ZT117==15001 & ZT118==49999;
replace temp=50000 if ZT117==50000 & ZT118==50000;
replace temp=125000 if ZT117==50001 & ZT118==199999;
replace temp=200000 if ZT117==200000 & ZT118==200000;
replace temp=1100000  if ZT117==200001 & ZT118==2000000;
drop ZT116;
rename temp ZT116;


gen house13=ZT107 + ZT116;
replace house13=0 if (house13==.|house13>9000000);
*/
********************************************************************************


*replace ZT131=. if ZT131>9999000 & ZT131~=.;
*replace ZT140=. if ZT140>9999000 & ZT140~=.;

*gen re13=ZT131 + ZT140;
gen re13=.;
*replace re13=0 if (re13==.|re13>9000000);

replace estateflag13=2 if (ZT173~=. & ZT173<90000000);
replace estateflag13=3 if (ZT174>0 & ZT174<2000002)  & (ZT175>0 & ZT175<2000001); //**check with eric;
replace estateflag13=4 if ZT174==0 & ZT175<2000001 & ZT175~=.;
replace estateflag13=5 if ZT174>0 & ZT174~=. & ZT175>2000000 & ZT175~=.;
replace estateflag13=6 if ZT174 == 0 & ZT175 > 2000000;
replace estateflag13=1 if estateflag13==. & ZT173>999990000;                    //*check with eric;

********************** impute ZT173 using brackets ***********;

*update with post-exit data as done above in wave 9;

replace ZT175= 99999990 if ZT175>99999990 & ZT175<99999999999; // this makes missing value code bigger than max range value -- need this for imputations;

replace ZT174=0 if ZT174==. & (ZT173==99999998|ZT173==99999999);      //fix annoying quirk in data;
replace ZT175=99999990 if ZT175==. & (ZT173==99999998|ZT173==99999999);  // fix annoying quirk in data; //check this with Eric - previous waves might need work

gen mmiss=.;
replace mmiss=0 if ZT173>-100 & ZT173<99999990; // donor group;
replace mmiss=1 if ZT173>99999990 & ZT173<19999999991; // missing variable code;

replace exactvalue=ZT173;
replace lowervalue=ZT174;
replace uppervalue=ZT175;

imputethis;
gen estate13=exactvalue;

*replace VT242=WPT242 if VT242==.|VT242==8|VT242==9; //uncomment this line and update prefixes when we get post exit info for wave 13;
replace estate13=estate13+house13 if ZT242==5;



/*
gen temp=.;
replace temp=1 if YT173~=. & YT173<99999998;
*used to set observations with guess==1 to the mean below, might need to adjust upper bound in future waves
tab YT174 YT175;
gen guess = 0;
replace guess = 1 if YT174 == 0 & YT175 > 2000000;
sum YT173 YT174 YT175;
gen impute=0;
replace impute=1 if (YT173==.|YT173>99999000);
replace YT173=0 if (YT173==.|YT173>99999000);
egen mymin = min(YT175/5) if (YT175~=0 & YT175~=.);
egen mymax = max(YT174) if YT174~=.;
replace YT174 = mymin if YT174==0;
drop mymin;
replace YT175=mymax if YT175>2000000 & YT175~=.; 
drop mymax;
replace YT173=sqrt(YT174*YT175) if (YT174~=. & YT175~=.);
sum YT173 if temp==1;
replace YT173 = r(mean) if guess == 1; 
sort impute;
by impute: sum YT173 YT174 YT175;
sort guess;
by guess: sum YT173 YT174 YT175 if impute==1;
drop guess impute temp;
gen estate12=YT173;
*/


********************** impute ZT186 using brackets ***********;

replace ZT188=9999990 if ZT188>99999990 & ZT188<99999999999; // this makes missing value code bigger than max range value -- need this for imputations;

replace ZT187=0 if ZT187==. & (ZT186==9999998|ZT186==9999999);      //fix annoying quirk in data;
replace ZT188=9999990 if ZT188==. & (ZT186==9999998|ZT186==9999999);  // fix annoying quirk in data;
*check this with eric;
gen mmiss=.;
replace mmiss=0 if ZT186>-100 & ZT186<9999990; // donor group;
replace mmiss=1 if ZT186>9999990 & ZT186<19999991; // missing variable code;

replace exactvalue=ZT186;
replace lowervalue=ZT187;
replace uppervalue=ZT188;

imputethis;
gen inspay13=exactvalue;

/*
gen temp=.;
replace temp=1 if YT186~=. & YT186<9999998; 
*used to set observations with guess==1 to the mean below, might need to adjust upper bound in future waves
tab YT187 YT188;
gen guess = 0;
replace guess = 1 if YT187 == 0 & YT188 > 100000;
sum YT186 YT187 YT188;
gen impute=0;
replace impute=1 if (YT186==.|YT186>9999900);
replace YT186=0 if (YT186==.|YT186>9999900);
egen mymin=min(YT188/5) if (YT188~=0 & YT188~=.);
egen mymax=max(YT187) if YT187~=.;
replace YT187=mymin if YT187==0;
drop mymin;
replace YT188=mymax if YT188>mymax & YT188~=.;
drop mymax;
replace YT186=sqrt(YT187*YT188) if (YT187~=. & YT188~=.);
sum YT186 if temp==1;
replace YT186 = r(mean) if guess == 1; 
sort impute;
by impute: sum YT186 YT187 YT188;
sort guess;
by guess: sum YT186 YT187 YT188 if impute==1;
drop guess impute temp;

gen inspay13=ZT186;
*/

********************** impute ZT148 using brackets ***********;

replace ZT150=9999990 if ZT150>99999990 & ZT150<99999999999; // this makes missing value code bigger than max range value -- need this for imputations;

replace ZT149=0 if ZT149==. & ZT148>99990 & ZT148<99999999999;      //fix annoying quirk in data;
replace ZT150=9999990 if ZT150==. & ZT148>99990 & ZT148<99999999999;  // fix annoying quirk in data;

gen mmiss=.;
replace mmiss=0 if ZT148>-100 & ZT148<100000; // donor group;
replace mmiss=1 if ZT148>100000 & ZT148<19999999991; // missing variable code;
* Chris, this looks odd;
replace exactvalue=ZT148;
replace lowervalue=ZT149;
replace uppervalue=ZT150;

imputethis;
gen deathex13=exactvalue;
replace deathex13 =. if deathex13 ==99998 | deathex13 ==99997 | deathex13 ==99996 | deathex13 ==99999;
/*
gen temp=.;
replace temp=1 if YT148~=. & YT148<99996;
*used to set observations with guess==1 to the mean below, might need to adjust upper bound in future waves
tab YT149 YT150;
gen guess = 0;
replace guess = 1 if YT149 == 0 & YT150 > 25000;
sum YT148 YT149 YT150;
gen impute=0;
replace impute=1 if (YT148==.|YT148>99990);
replace YT148=0 if (YT148==.|YT148>99990);
egen mymin=min(YT150/5) if (YT150~=0 & YT150~=.);
egen mymax=max(YT149) if YT149~=.;
replace YT149=mymin if YT149==0;  
drop mymin;
replace YT150=mymax if YT150>mymax & YT150~=.;
drop mymax;
replace YT148=sqrt(YT149*YT150) if (YT149~=. & YT150~=.);
sum YT148 if temp==1;
replace YT148 = r(mean) if guess == 1;
sort impute;
by impute: sum YT148 YT149 YT150;
sort guess;
by guess: sum YT148 YT149 YT150 if impute==1;
drop guess impute temp;

gen deathex12=YT148;
*/


********************** impute amspouse13 using brackets ***********;

**********************Uncomment below and update prefixes when post-exit data is available**************************;

gen amspouse13=ZT9002 if ZT9002<9999998;
replace amspouse13=estate13*ZT9003/100 if amspouse13==. & ZT9003<101;
*replace amspouse9=WPT9002 if WPT9002<9999998 & amspouse9==.;
*replace amspouse9=estate9*WPT9003/100 if amspouse9==. & WPT9003<101;
replace amspouse13=estate13 if amspouse13==100;

*replace VT9004=WPT9004 if WPT9004~=. & (VT9004==.|VT9004==8|VT9004==9) & VT9005==. & VT9006==. & VT9007==. & VT9008==.;
*replace VT9005=WPT9005 if WPT9005~=. & VT9004==1 & (VT9005==.|VT9005==8|VT9005==9) & VT9006==. & VT9007==. & VT9008==.; 
*replace VT9006=WPT9006 if WPT9006~=. & VT9004==1 & VT9005==1 & (VT9006==.|VT9006==8|VT9007==9) & VT9007==. & VT9008==.;
*replace VT9007=WPT9007 if WPT9007~=. & VT9004==5 & (VT9007==.|VT9007==8|VT9007==9) & VT9005==. & VT9006==. & VT9008==.;
*replace VT9008=WPT9008 if WPT9008~=. & VT9004==5 & VT9007==5 & (VT9008==.|VT9008==8|VT9008==9) & VT9005==. & VT9006==.;


drop lowervalue uppervalue;
replace exactvalue=amspouse13/estate13*100;
replace exactvalue=100 if exactvalue>100 & exactvalue<.;

gen lowervalue=50 if ZT9004==1;
gen uppervalue=50 if ZT9004==5;
replace lowervalue=75 if ZT9005==1;
replace uppervalue=75 if ZT9005==5;
replace lowervalue=90 if ZT9006==1;
replace uppervalue=90 if ZT9006==5;
replace lowervalue=25 if ZT9007==1;
replace uppervalue=25 if ZT9007==5;
replace lowervalue=10 if ZT9008==1;
replace uppervalue=10 if ZT9008==5;
replace lowervalue=0 if ZT9008==5;
replace uppervalue=100 if ZT9006==1;

replace lowervalue=0 if (lowervalue==. & uppervalue~=.)|(ZT9004==8|ZT9004==9);
replace uppervalue=100 if (lowervalue~=. & uppervalue==.)|(ZT9004==8|ZT9004==9);

replace exactvalue=998 if exactvalue==. & lowervalue~=.;

gen mmiss=.;
replace mmiss=0 if exactvalue>-1 & exactvalue<101; // donor group;
replace mmiss=1 if exactvalue>100 & exactvalue<9999; // missing variable code;

imputethis;
replace amspouse13=estate13*exactvalue/100;


gen deathins13=ZT153;
gen temp=deathins13;
replace temp=. if deathins13>9990000 & deathins13~=.;
drop deathins13;
rename temp deathins13;



gen housebequeathA13=ZT102;
gen housebequeathB13=ZT111;
*gen housebequeathC13=ZT126;  
* PHIL: I can't find this one *JON: (Neither can I);
*gen housebequeathD12=YT135; *Ali: Question taken out of wave 12;




keep death*  HHID PN house* estate* inspay*  HHID PN housebeq* house* estate* inspay* deathex* amsp*  ZT116;
gen temp=real(HHID);
drop HHID;
rename temp HHID;
gen temp=real(PN);
drop PN;
rename temp PN;
sort HHID PN;

sort HHID PN;
merge HHID PN using `saved'exitassets;
drop _merge;


summ  HHID PN death* estate* inspay* re* HHID PN  house* estate* ins*;
keep   HHID PN death* estate* inspay* re* HHID PN  house* estate* ins* amsp*;  

sort HHID PN;
save `saved'exitassets, replace;


**********************************End Wave 13**********************;


**********************************Start Wave 14**********************;
* Added by Chris;
clear; 
* Chris: I've deleted the commented "OLD IMPUTATION" code in below, as it clutters up the file and appears not to be used anywhere. 
* ZT variable names are XQT in wave 14;

*******************read in post-exit data and update prefixes/year below when post-exit comes out for wave 14**************; 

***post-exit data***;*************;
*use `wave15d'px20T_R;           *;
*keep if ZPEXITIW==2018;         *;
*sort HHID PN;                   *Uncomment this when final post-exit data are out and added to the dropbox;
*tempfile temp;                  *Chris: It's not there as of Sep 2022;
*save `temp', replace;           *;
********************;*************;

use `wave14d'X18T_R, clear; //data is not imputed;


****merge in post exit data below********;
*merge 1:1 HHID PN using `temp'; 


gen estateflag14=.;
*gen housebequeathA1=.;
*gen housebequeathB1=.;
*gen housebequeathC1=.;
*gen housebequeathD1=.;

********************** impute XQT107 and XQT116 using brackets ***********;

*sum XQT107 if XQT107~=. & XQT116~=. //check that variables are mutually exclusive (should be 0 observations);
*    Variable |        Obs        Mean    Std. Dev.       Min        Max;
*-------------+---------------------------------------------------------;
*       XQT107 |          0;

*update with post-exit data as done above in wave 9;

replace XQT107=0 if XQT107==. & XQT116~=.;
replace XQT116=0 if XQT116==. & XQT107~=.;
replace XQT108=0 if XQT108==. & XQT117~=.;
replace XQT117=0 if XQT117==. & XQT108~=.;
replace XQT109=0 if XQT109==. & XQT118~=.;
replace XQT118=0 if XQT118==. & XQT109~=.;
*   EXIT SOLD HOME AMT;
* XQT107      999998.  DK (Don't Know)  NA (Not Ascertained);
*             999999.  RF (Refused);
* VALUE MAIN RES II;
* XQT116      9999998.  DK (Don't Know)  NA (Not Ascertained);
*             9999999.  RF (Refused);


gen house14 = XQT107 + XQT116;
*Have a look at this = it is similar to previous waves;
* Chris checked this but adding them might mean the missing values are potentailly e.g. 999998 + 9999998=10999996;
replace XQT109= 9999990 if XQT109>99999000 & XQT109<99999999999; // this makes missing value code bigger than max range value -- need this for imputations;
* Chris checked this;
replace XQT118= 9999990 if XQT118>99999000 & XQT118<99999999999; //make sure that DK/NA/Refused and above-breakpoint codes haven't changed since previous round
* Chris checked this;

gen mmiss=.;
replace mmiss=0 if house14>-100 & house14<9999991; // donor group;
replace mmiss=1 if house14>9999990 & house14<19999001; // missing variable code;


gen lowervalue= XQT108 + XQT117;
gen uppervalue= XQT109 + XQT118;

replace lowervalue=0 if lowervalue==. & (house14==9999998|house14==9999999);      //fix annoying quirk in data;
replace uppervalue=99999996 if uppervalue==. & (house14==9999998|house14==9999999);  // fix annoying quirk in data;

gen exactvalue=house14;

imputethis;
replace house14=exactvalue;

*replace XQT131=. if XQT131>9999000 & XQT131~=.;
*replace XQT140=. if XQT140>9999000 & XQT140~=.;

*gen re13=XQT131 + XQT140;
gen re14=.;
*replace re14=0 if (re14==.|re14>9000000);

replace estateflag14=2 if (XQT173~=. & XQT173<90000000);
replace estateflag14=3 if (XQT174>0 & XQT174<2000002)  & (XQT175>0 & XQT175<2000001); //**check with eric;
replace estateflag14=4 if XQT174==0 & XQT175<2000001 & XQT175~=.;
replace estateflag14=5 if XQT174>0 & XQT174~=. & XQT175>2000000 & XQT175~=.;
replace estateflag14=6 if XQT174 == 0 & XQT175 > 2000000;
replace estateflag14=1 if estateflag14==. & XQT173>999990000;                    //*check with eric;

********************** impute XQT173 using brackets ***********;

*update with post-exit data as done above in wave 9;

replace XQT175= 99999990 if XQT175>99999990 & XQT175<99999999999; // this makes missing value code bigger than max range value -- need this for imputations;
* Chris checked this;

replace XQT174=0 if XQT174==. & (XQT173==99999998|XQT173==99999999);      //fix annoying quirk in data;
replace XQT175=99999990 if XQT175==. & (XQT173==99999998|XQT173==99999999);  // fix annoying quirk in data; //check this with Eric - previous waves might need work

gen mmiss=.;
replace mmiss=0 if XQT173>-100 & XQT173<99999990; // donor group;
replace mmiss=1 if XQT173>99999990 & XQT173<19999999991; // missing variable code;
* Chris checked this;

replace exactvalue=XQT173;
replace lowervalue=XQT174;
replace uppervalue=XQT175;

imputethis;
gen estate14=exactvalue;

*replace VT242=WPT242 if VT242==.|VT242==8|VT242==9; //uncomment this line and update prefixes when we get post exit info for wave 14;
replace estate14=estate14+house14 if XQT242==5;



/*
gen temp=.;
replace temp=1 if YT173~=. & YT173<99999998;
*used to set observations with guess==1 to the mean below, might need to adjust upper bound in future waves
tab YT174 YT175;
gen guess = 0;
replace guess = 1 if YT174 == 0 & YT175 > 2000000;
sum YT173 YT174 YT175;
gen impute=0;
replace impute=1 if (YT173==.|YT173>99999000);
replace YT173=0 if (YT173==.|YT173>99999000);
egen mymin = min(YT175/5) if (YT175~=0 & YT175~=.);
egen mymax = max(YT174) if YT174~=.;
replace YT174 = mymin if YT174==0;
drop mymin;
replace YT175=mymax if YT175>2000000 & YT175~=.; 
drop mymax;
replace YT173=sqrt(YT174*YT175) if (YT174~=. & YT175~=.);
sum YT173 if temp==1;
replace YT173 = r(mean) if guess == 1; 
sort impute;
by impute: sum YT173 YT174 YT175;
sort guess;
by guess: sum YT173 YT174 YT175 if impute==1;
drop guess impute temp;
gen estate12=YT173;
*/


********************** impute XQT186 using brackets ***********;

replace XQT188=9999990 if XQT188>99999990 & XQT188<99999999999; // this makes missing value code bigger than max range value -- need this for imputations;
* Chris checked this;
replace XQT187=0 if XQT187==. & (XQT186==9999998|XQT186==9999999);      //fix annoying quirk in data;
replace XQT188=9999990 if XQT188==. & (XQT186==9999998|XQT186==9999999);  // fix annoying quirk in data;
*check this with eric;
gen mmiss=.;
replace mmiss=0 if XQT186>-100 & XQT186<9999990; // donor group;
replace mmiss=1 if XQT186>9999990 & XQT186<19999991; // missing variable code;
* Chris checked this;
*						  9999998.  DK (Don't Know)  NA (Not Ascertained);
*						  9999999.  RF (Refused);

replace exactvalue=XQT186;
replace lowervalue=XQT187;
replace uppervalue=XQT188;

imputethis;
gen inspay14=exactvalue;

/*
gen temp=.;
replace temp=1 if YT186~=. & YT186<9999998; 
*used to set observations with guess==1 to the mean below, might need to adjust upper bound in future waves
tab YT187 YT188;
gen guess = 0;
replace guess = 1 if YT187 == 0 & YT188 > 100000;
sum YT186 YT187 YT188;
gen impute=0;
replace impute=1 if (YT186==.|YT186>9999900);
replace YT186=0 if (YT186==.|YT186>9999900);
egen mymin=min(YT188/5) if (YT188~=0 & YT188~=.);
egen mymax=max(YT187) if YT187~=.;
replace YT187=mymin if YT187==0;
drop mymin;
replace YT188=mymax if YT188>mymax & YT188~=.;
drop mymax;
replace YT186=sqrt(YT187*YT188) if (YT187~=. & YT188~=.);
sum YT186 if temp==1;
replace YT186 = r(mean) if guess == 1; 
sort impute;
by impute: sum YT186 YT187 YT188;
sort guess;
by guess: sum YT186 YT187 YT188 if impute==1;
drop guess impute temp;

gen inspay13=XQT186;
*/

********************** impute XQT148 using brackets ***********;

replace XQT150=9999990 if XQT150>99999990 & XQT150<99999999999; // this makes missing value code bigger than max range value -- need this for imputations;
* Chris checked this;
replace XQT149=0 if XQT149==. & XQT148>99990 & XQT148<99999999999;      //fix annoying quirk in data;
replace XQT150=9999990 if XQT150==. & XQT148>99990 & XQT148<99999999999;  // fix annoying quirk in data;

gen mmiss=.;
replace mmiss=0 if XQT148>-100 & XQT148<100000; // donor group;
replace mmiss=1 if XQT148>100000 & XQT148<19999999991; // missing variable code;
* Chris, looks odd, maybe handled by next 3 lines;
replace exactvalue=XQT148;
replace lowervalue=XQT149;
replace uppervalue=XQT150;

imputethis;
gen deathex14=exactvalue;
replace deathex14 =. if deathex14 ==99998 | deathex14 ==99997 | deathex14 ==99996 | deathex14 ==99999;
/*
gen temp=.;
replace temp=1 if YT148~=. & YT148<99996;
*used to set observations with guess==1 to the mean below, might need to adjust upper bound in future waves
tab YT149 YT150;
gen guess = 0;
replace guess = 1 if YT149 == 0 & YT150 > 25000;
sum YT148 YT149 YT150;
gen impute=0;
replace impute=1 if (YT148==.|YT148>99990);
replace YT148=0 if (YT148==.|YT148>99990);
egen mymin=min(YT150/5) if (YT150~=0 & YT150~=.);
egen mymax=max(YT149) if YT149~=.;
replace YT149=mymin if YT149==0;  
drop mymin;
replace YT150=mymax if YT150>mymax & YT150~=.;
drop mymax;
replace YT148=sqrt(YT149*YT150) if (YT149~=. & YT150~=.);
sum YT148 if temp==1;
replace YT148 = r(mean) if guess == 1;
sort impute;
by impute: sum YT148 YT149 YT150;
sort guess;
by guess: sum YT148 YT149 YT150 if impute==1;
drop guess impute temp;

gen deathex12=YT148;
*/


********************** impute amspouse13 using brackets ***********;

**********************Uncomment below and update prefixes when post-exit data is available**************************;

gen amspouse14=XQT9002 if XQT9002<9999998;
replace amspouse14=estate14*XQT9003/100 if amspouse14==. & XQT9003<101;
*replace amspouse9=WPT9002 if WPT9002<9999998 & amspouse9==.;
*replace amspouse9=estate9*WPT9003/100 if amspouse9==. & WPT9003<101;
replace amspouse14=estate14 if amspouse14==100;

*replace VT9004=WPT9004 if WPT9004~=. & (VT9004==.|VT9004==8|VT9004==9) & VT9005==. & VT9006==. & VT9007==. & VT9008==.;
*replace VT9005=WPT9005 if WPT9005~=. & VT9004==1 & (VT9005==.|VT9005==8|VT9005==9) & VT9006==. & VT9007==. & VT9008==.; 
*replace VT9006=WPT9006 if WPT9006~=. & VT9004==1 & VT9005==1 & (VT9006==.|VT9006==8|VT9007==9) & VT9007==. & VT9008==.;
*replace VT9007=WPT9007 if WPT9007~=. & VT9004==5 & (VT9007==.|VT9007==8|VT9007==9) & VT9005==. & VT9006==. & VT9008==.;
*replace VT9008=WPT9008 if WPT9008~=. & VT9004==5 & VT9007==5 & (VT9008==.|VT9008==8|VT9008==9) & VT9005==. & VT9006==.;


drop lowervalue uppervalue;
replace exactvalue=amspouse14/estate14*100;
replace exactvalue=100 if exactvalue>100 & exactvalue<.;

gen lowervalue=50 if XQT9004==1;
gen uppervalue=50 if XQT9004==5;
replace lowervalue=75 if XQT9005==1;
replace uppervalue=75 if XQT9005==5;
replace lowervalue=90 if XQT9006==1;
replace uppervalue=90 if XQT9006==5;
replace lowervalue=25 if XQT9007==1;
replace uppervalue=25 if XQT9007==5;
replace lowervalue=10 if XQT9008==1;
replace uppervalue=10 if XQT9008==5;
replace lowervalue=0 if XQT9008==5;
replace uppervalue=100 if XQT9006==1;

replace lowervalue=0 if (lowervalue==. & uppervalue~=.)|(XQT9004==8|XQT9004==9);
replace uppervalue=100 if (lowervalue~=. & uppervalue==.)|(XQT9004==8|XQT9004==9);

replace exactvalue=998 if exactvalue==. & lowervalue~=.;

gen mmiss=.;
replace mmiss=0 if exactvalue>-1 & exactvalue<101; // donor group;
replace mmiss=1 if exactvalue>100 & exactvalue<9999; // missing variable code;

imputethis;
replace amspouse14=estate14*exactvalue/100;


gen deathins14=XQT153;
gen temp=deathins14;
replace temp=. if deathins14>9990000 & deathins14~=.;
drop deathins14;
rename temp deathins14;



gen housebequeathA14=XQT102;
gen housebequeathB14=XQT111;
*gen housebequeathC13=XQT126;  
* PHIL: I can't find this one *JON: (Neither can I);
*gen housebequeathD12=YT135; *Ali: Question taken out of wave 12;




keep death*  HHID PN house* estate* inspay*  HHID PN housebeq* house* estate* inspay* deathex* amsp*  XQT116;
gen temp=real(HHID);
drop HHID;
rename temp HHID;
gen temp=real(PN);
drop PN;
rename temp PN;
sort HHID PN;

sort HHID PN;
merge HHID PN using `saved'exitassets;
drop _merge;


summ  HHID PN death* estate* inspay* re* HHID PN  house* estate* ins*;
keep   HHID PN death* estate* inspay* re* HHID PN  house* estate* ins* amsp*;  

sort HHID PN;
save `saved'exitassets, replace;

**********************************End Wave 14**********************;


***********************************************************************;
* what to do about the missings? set them =0 here, but check things out;
***********************************************************************;

replace deathex3=0 if estate3~=. & deathex3==.;
replace deathins3=0 if estate3~=. & deathins3==.;
replace inspay3=0 if estate3~=. & inspay3==.;

replace deathex4=0 if estate4~=. & deathex4==.;
replace deathins4=0 if estate4~=. & deathins4==.;
replace inspay4=0 if estate4~=. & inspay4==.;

replace deathex5=0 if estate5~=. & deathex5==.;
replace deathins5=0 if estate5~=. & deathins5==.;
replace inspay5=0 if estate5~=. & inspay5==.;

* this one is a little sketchy, as the imputed variables are not yet in;
replace deathex6=0 if estate6~=. & deathex6==.;
replace deathins6=0 if estate6~=. & deathins6==.;
replace inspay6=0 if estate6~=. & inspay6==.;


* this one is a little sketchy, as the imputed variables are not yet in;
replace deathex7=0 if estate7~=. & deathex7==.;
replace deathins7=0 if estate7~=. & deathins7==.;
replace inspay7=0 if estate7~=. & inspay7==.;


* this one is a little sketchy, as the imputed variables are not yet in;
replace deathex8=0 if estate8~=. & deathex8==.;
replace deathins8=0 if estate8~=. & deathins8==.;
replace inspay8=0 if estate8~=. & inspay8==.;

* this one is a little sketchy, as the imputed variables are not yet in;
replace deathex9=0 if estate9~=. & deathex9==.;
replace deathins9=0 if estate9~=. & deathins9==.;
replace inspay9=0 if estate9~=. & inspay9==.;

* this one is a little sketchy, as the imputed variables are not yet in;
replace deathex10=0 if estate10~=. & deathex10==.;
replace deathins10=0 if estate10~=. & deathins10==.;
replace inspay10=0 if estate10~=. & inspay10==.;


* this one is a little sketchy, as the imputed variables are not yet in;
replace deathex11=0 if estate11~=. & deathex11==.;
replace deathins11=0 if estate11~=. & deathins11==.;
replace inspay11=0 if estate11~=. & inspay11==.;

* this one is a little sketchy, as the imputed variables are not yet in;
replace deathex12=0 if estate12~=. & deathex12==.;
replace deathins12=0 if estate12~=. & deathins12==.;
replace inspay12=0 if estate12~=. & inspay12==.;
summ  HHID PN death* estate* inspay* re* HHID PN  house* estate* ins*;

replace inspay12=0 if inspay12>500000 & inspay12<1000000;
replace deathins12=0 if deathins12>33000 & deathins12<1000000;


* this one is a little sketchy, as the imputed variables are not yet in;
replace deathex13=0 if estate13~=. & deathex13==.;
replace deathins13=0 if estate13~=. & deathins13==.;
replace inspay13=0 if estate13~=. & inspay13==.;
summ  HHID PN death* estate* inspay* re* HHID PN  house* estate* ins*;

replace inspay13=0 if inspay13>500000 & inspay13<1000000;
replace deathins13=0 if deathins13>33000 & deathins13<1000000;

* added by Chris;
replace deathex14=0 if estate14~=. & deathex14==.;
replace deathins14=0 if estate14~=. & deathins14==.;
replace inspay14=0 if estate14~=. & inspay14==.;
summ  HHID PN death* estate* inspay* re* HHID PN  house* estate* ins*;

replace inspay14=0 if inspay14>500000 & inspay14<1000000;
replace deathins14=0 if deathins14>33000 & deathins14<1000000;
* end added by Chris;

summ  HHID PN death* estate* inspay* re* HHID PN  house* estate* ins*;

sort HHID PN;
save `saved'exitassets, replace;

*drop _all;
* compare summary stats before and after;
cd "$folder\hrs\merge\compare\" ;
summtab, contvars(_all) mean median range excel excelname(exitassets.xlsx) replace;
cd "$folder\hrs\merge\" ;
use exitassets.old.dta , clear;
cd "$folder\hrs\merge\compare\" ;
summtab, contvars(_all) mean median range excel excelname(exitassets.xlsx) sheetname(Old);

cap log close;
program drop _all;